/**
 * NOTICE OF LICENSE
 *
 * This file is licenced under the Software License Agreement.
 * With the purchase or the installation of the software in your application
 * you accept the licence agreement.
 *
 * @author    Presta.Site
 * @copyright 2015 Presta.Site
 * @license   LICENSE.txt
 */

$(function(){
    $('#hide-warning').on('click', function(){
        $('.warning-wrp').slideUp('fast', function(){
            $(this).detach().appendTo('#module_form_1').show();
        });
        $(this).hide();

        $.ajax({
            type: 'POST',
            headers: {"cache-control": "no-cache"},
            url: psbackup_ajax_url + '?rand=' + new Date().getTime(),
            async: true,
            cache: false,
            dataType: "json",
            data: 'ajax=1&hide_warning=1'
        });
    });

    $('body').on('click', '.psbackup-table .remove-link', function(e){
        e.preventDefault();
        if(!confirm(psbackup_deletion_alert))
            return false;

        var link_obj = $(this);
        if(link_obj.hasClass('in-progress'))
            return false;

        link_obj.addClass('in-progress');

        var filename = $(this).attr('id');
        var type = $(this).attr('data-type');
        var request_type = 'delete_local';
        var gdrive_id = '';
        if(link_obj.hasClass('remove-link-gdrive')) {
            var gdrive_id = link_obj.attr('data-gdrive-id');
            request_type = 'delete_gdrive';
        }

        $.ajax({
            type: 'POST',
            headers: {"cache-control": "no-cache"},
            url: psbackup_ajax_url + '?rand=' + new Date().getTime(),
            async: true,
            cache: false,
            dataType: "json",
            data: 'ajax=1&' + request_type + '=1&filename=' + filename + '&type=' + type + '&gdrive_id=' + gdrive_id,
            success: function(json) {
                if(json.success == 1) {
                    var search = (gdrive_id ? '.download-link' : '.gdrive-download-link');

                    if(link_obj.parents('tr').find(search).length) {
                        if(gdrive_id) {
                            var html = '<a href="#" class="gdrive-upload-link" id="' + filename + '" data-type="' + type + '"><i class="icon-upload"></i> ' + psbackup_text_upload + '</a>';
                            link_obj.parents('td').html(html);
                        }
                        else
                            link_obj.parents('td').html('');
                    }
                    else {
                        link_obj.parents('tr').fadeOut(300, function () {
                            link_obj.parents('tr').remove();
                        });
                    }
                }
                else {
                    link_obj.addClass('error').text(psbackup_text_error);
                }
            },
            error: function() {
                link_obj.addClass('error').text(psbackup_text_error);
            },
            complete: function() {
                link_obj.removeClass('in-progress');
            }
        });
    });

    $('body').on('click', '.gdrive-upload-link', function(e){
        e.preventDefault();
        var link_obj = $(this);
        if(link_obj.hasClass('in-progress'))
            return false;

        link_obj.addClass('in-progress');

        var filename = $(this).attr('id');
        var type = $(this).attr('data-type');

        $.ajax({
            type: 'POST',
            headers: {"cache-control": "no-cache"},
            url: psbackup_ajax_url + '?rand=' + new Date().getTime(),
            async: true,
            cache: false,
            dataType: "json",
            data: 'ajax=1&upload_backup=1&filename=' + filename + '&type=' + type,
            success: function(json) {
                if(json.success == 1) {
                    var html = '<a class="gdrive-download-link" href="' + json.gdrive_url + '"><i class="icon-download"></i> ' + psbackup_text_download + '</a>' +
                        '&nbsp;|&nbsp;' +
                        '<a href="#" class="remove-link remove-link-gdrive" id="' + json.filename + '" data-gdrive-id="' + json.gdrive_id + '"><i class="icon-remove"></i> ' + psbackup_text_delete + '</a>';
                    link_obj.parents('td').html(html);
                }
                else {
                    link_obj.addClass('error').text(psbackup_text_error);
                }
            },
            error: function() {
                link_obj.addClass('error').text(psbackup_text_error);
            },
            complete: function() {
                link_obj.removeClass('in-progress');
            }
        });
    });

    $('body').on('click', '.psbckp-restore', function(e){
        e.preventDefault();

        $('#psbckp-restore-success').hide();
        $('#psbckp-errors').hide();

        var filename = $(this).attr('data-filename');
        var type = $(this).attr('data-type');
        var gdrive_url = $(this).attr('data-gdrive-url');

        $('#psbckp-restore-confirm').attr('data-filename', filename);
        $('#psbckp-restore-confirm').attr('data-type', type);
        $('#psbckp-restore-confirm').attr('data-gdrive-url', gdrive_url);

        $this = $(this);
        $.fancybox({
            href: $this.attr('href')
        });
    });

    $('body').on('click', '#psbckp-restore-cancel', function(e){
        $.fancybox.close();
    });

    $('body').on('click', '#psbckp-restore-confirm', function(e){
        e.preventDefault();

        $('#psbckp-restore-success').hide();
        $('#psbckp-errors').hide();

        var link_obj = $(this);
        if(link_obj.hasClass('in-progress'))
            return false;

        link_obj.addClass('in-progress');
        link_obj.parents('.btn-row').addClass('loading');

        var filename = $(this).attr('data-filename');
        var type = $(this).attr('data-type');
        var gdrive_url = $(this).attr('data-gdrive-url');

        $.ajax({
            type: 'POST',
            headers: {"cache-control": "no-cache"},
            url: psbackup_ajax_url + '?rand=' + new Date().getTime(),
            async: true,
            cache: false,
            dataType: "json",
            data: 'ajax=1&restore_backup=1&filename=' + filename + '&type=' + type + '&gdrive_url=' + gdrive_url,
            success: function(json) {
                if(json.success == 1 && !json.errors) {
                    $('#psbckp-restore-success').slideDown(400);
                } else if(json.success == 1 && json.errors) {
                    $('#psbckp-restore-success').slideDown(400);
                    $('#psbckp-errors').html(json.errors).slideDown(400);
                } else {
                    $('#psbckp-errors').html(psbackup_text_error_unknown).slideDown(400);
                }
            },
            error: function(jqXHR) {
                $('#psbckp-errors').html(psbackup_text_error_unknown + '<br/>' + String(jqXHR.responseText)).slideDown(400);
            },
            complete: function() {
                link_obj.removeClass('in-progress');
                link_obj.parents('.btn-row').removeClass('loading');
            }
        });
    });

    $('body').on('click', '#psbackup-show-unwritable', function(e){
        e.preventDefault();

        if ($('.psbackup-unwritable').is(':visible')) {
            $('.psbackup-unwritable').slideUp(300);
            var text = $(this).attr('data-show-text');
        } else {
            $('.psbackup-unwritable').slideDown(300);
            var text = $(this).attr('data-hide-text');
        }
        $(this).text(text);
    });
});