<?php
/**
 * ShopiMind
 *
 * @author Shopimind <contact@shopimind.com>
 * @copyright Copyright (c) 2013 - IDVIVE SARL (http://www.idvive.com)
 * @license New BSD license (http://license.idvive.com)
 * @package ShopiMind
 * @version $Id shopimind.php 2013-04-23$
 */

if (!defined('_PS_VERSION_')) {
    exit();
}

class ShopiMind extends Module
{

    protected $client;


    protected $scriptDisplayed = false;

    protected $confirm_cart_to_order = false;

    public function __construct()
    {
        $this->name = 'shopimind';
        $this->tab = 'advertising_marketing';
        $this->version = '4.2.4';
        $this->author = 'PrestaShop Partners';
        $this->need_instance = 1;
        $this->module_key = '0cd2cda3885b61b9ae396e0851607de7';
        $this->secure_key = Tools::encrypt($this->name);
        $this->controllers = ['ajaxspmq'];

        if (_PS_VERSION_ < '1.6') {
            $this->bootstrap = false;
        } else {
            $this->bootstrap = true;
        }

        $this->ps_versions_compliancy = [
            'min' => '1.4',
            'max' => _PS_VERSION_
        ];

        parent::__construct();

        $this->displayName = $this->l('ShopiMind');
        $this->description = $this->l('Relaunch your abandoned carts, contact your prospects, build customer loyalty. Shopimind allows you to automate your customer relationships and increase your sales.');

        if (_PS_VERSION_ < '1.5') {
            require(_PS_MODULE_DIR_.$this->name.'/backward_compatibility/backward.php');
        }
    }

    public function install()
    {
        if (Module::isInstalled('shopymind')) {
            Module::disableByName($this->name);
            $this->_errors[] = $this->l('You must first uninstall Module shopymind.');
        }

        if (!function_exists('curl_init')) {
            $this->_errors[] = $this->l('ShopiMind requires PHP Curl extension, please ask your hosting provider to enable this extension before installing this module.');
        }

        $this->updateModule();
        if (version_compare(_PS_VERSION_, "1.5", '<')) {
            if ((is_array($this->_errors) && count($this->_errors)) ||
                !parent::install() ||
                !$this->registerHook('orderConfirmation') ||
                !$this->registerHook('footer') ||
                !$this->registerHook('header') ||
                !$this->registerHook('updateOrderStatus') ||
                !$this->registerHook('createAccount') ||
                !$this->registerHook('backOfficeHeader') ||
                !$this->registerHook('updateProduct') ||
                !$this->registerHook('deleteProduct') ||
                !$this->registerHook('addProduct') ||
                !$this->registerHook('categoryAddition') ||
                !$this->registerHook('categoryUpdate') ||
                !$this->registerHook('categoryDeletion') ||
                !$this->registerHook('updateQuantity')) {
                return false;
            }
        } else {
            if ((is_array($this->_errors) && count($this->_errors)) ||
                !parent::install() ||
                !$this->registerHook('displayOrderConfirmation') ||
                !$this->registerHook('actionUpdateOrderStatus') ||
                !$this->registerHook('actionOrderStatusUpdate') ||
                !$this->registerHook('actionObjectUpdateAfter') ||
                !$this->registerHook('actionObjectDeleteAfter') ||
                !$this->registerHook('actionObjectAddAfter') ||
                !$this->registerHook('displayBackOfficeHeader') ||
                !$this->registerHook('displayHeader') ||
                !$this->registerHook('displayFooter')) {
                return false;
            }
        }
        $this->connectShopToSPM();

        return true;
    }

    public function updateModule()
    {
        if (_PS_VERSION_ < '1.5') {
            Configuration::updateValue('SPM_voucherCumulablePromo', true);
        }

        if (_PS_VERSION_ < '1.4') {
            Configuration::updateValue('SPM_voucherHighlight', false);
        }

        Db::getInstance()->Execute('DROP TABLE IF EXISTS  `'._DB_PREFIX_.'spmcartoorder`');
    }

    protected function connectShopToSPM(
        $oldApiIdentification = null,
        $oldApiPassword = null,
        $newApiIdentification = null,
        $newApiPassword = null,
        $just_activate = false
    ) {
        require_once _PS_MODULE_DIR_.$this->name.'/ShopimindClient/bin/Configuration.php';
        $apiIdentification = Configuration::get('SPM_apiIdentification');
        $apiPassword = Configuration::get('SPM_apiPassword');

        /* Au cas ou nous n'arrivons pas à récupérer la clé api via les lignes au dessus*/
        if (!$apiIdentification || !$apiPassword) {
            $apiIdentification = $newApiIdentification;
            $apiPassword = $newApiPassword;
        }

        if (!$apiIdentification || !$apiPassword) {
            if (!is_null($oldApiIdentification) && !is_null($oldApiPassword)) {
                Configuration::updateValue('SPM_apiIdentification', $oldApiIdentification);
                Configuration::updateValue('SPM_apiPassword', $oldApiPassword);
            }
            return array(
                'success' => false,
                'message' => $this->l('Error while getting API\'s login.')
            );
        }
        $defaultCurrency = new Currency(Configuration::get('PS_CURRENCY_DEFAULT'));
        $defaultCurrency = $defaultCurrency->iso_code;

        $shop_id_shop = null;
        if ($this->multiShopIsActivate()) {
            $shop_id_shop = $this->context->shop->id;
        }

        $timezone = Configuration::get('PS_TIMEZONE');
        if (is_numeric($timezone)) {
            $tmz = Db::getInstance(_PS_USE_SQL_SLAVE_)->getRow('SELECT `name` 
            FROM '._DB_PREFIX_.'timezone WHERE id_timezone = '.(int)(Configuration::get('PS_TIMEZONE')));
            $timezone = $tmz['name'];
        }

        $defaultLang = Language::getIsoById(Configuration::get('PS_LANG_DEFAULT'));

        $forceSyncProducts = false;

        //Check if new product image sync is nedeed ($_POST['productImageSize'])
        if (Tools::getIsset('productImageSize')) {
            $oldProductImageSize = Configuration::get('SPM_productImageSize');

            if ($oldProductImageSize != Tools::getValue('productImageSize')) {
                $forceSyncProducts = true;
            }
        }

        // Récupération d'un instance et renseignement des paramètres
        $config = ShopimindClientConfiguration::factory(
            $apiIdentification,
            $apiPassword,
            $defaultLang,
            $defaultCurrency,
            $this->getContactPageUrl(),
            Configuration::get('PS_SHOP_PHONE'),
            $timezone,
            (bool)$this->isMultiShopContext(),
            $shop_id_shop,
            $forceSyncProducts,
            _PS_VERSION_,
            $this->version
        );
        try {
            // Sauvegarde du fichier de configuration
            if (!$config->testConnection()) {
                if (!is_null($oldApiIdentification) && !is_null($oldApiPassword)) {
                    Configuration::updateValue('SPM_apiIdentification', $oldApiIdentification);
                    Configuration::updateValue('SPM_apiPassword', $oldApiPassword);
                }
                return array(
                    'success' => false,
                    'message' => $this->l('Error during connection test.')." ".
                        $this->l('Please check that your site is not in maintenance mode or protected by an htaccess.')
                );
            } else {
                // Connexion au serveur et sauvegarde des informations
                $connect = $config->connectServer();

                if ($connect !== true) {
                    if (!is_null($oldApiIdentification) && !is_null($oldApiPassword)) {
                        Configuration::updateValue('SPM_apiIdentification', $oldApiIdentification);
                        Configuration::updateValue('SPM_apiPassword', $oldApiPassword);
                    }
                    return array(
                        'success' => false,
                        'message' => $this->l('Error during connection.')." ".
                            $this->l('Please check that your site is not in maintenance mode or protected by an htaccess.')
                    );
                } else {
                    if ($just_activate) {
                        return array(
                            'success' => true,
                            'message' => $this->l('Successful activation')." ".
                                $this->l('We have just sent you an email to finalize your registration.').
                                " ".$this->l('Open it and let yourself be guided.')
                        );
                    } else {
                        return array(
                            'success' => true,
                            'message' => $this->l('Configuration saved.')
                        );
                    }
                }
            }
        } catch (Exception $e) {
            if (!is_null($oldApiIdentification) && !is_null($oldApiPassword)) {
                Configuration::updateValue('SPM_apiIdentification', $oldApiIdentification);
                Configuration::updateValue('SPM_apiPassword', $oldApiPassword);
            }
            return array(
                'success' => false,
                'message' => $e->getMessage()
            );
        }
    }

    public function multiShopIsActivate()
    {
        return (bool)(_PS_VERSION_ >= 1.5 && Configuration::get('PS_MULTISHOP_FEATURE_ACTIVE'));
    }

    protected function getContactPageUrl()
    {
        if (_PS_VERSION_ < 1.5) {
            return Tools::getHttpHost(true).__PS_BASE_URI__.'contact-form.php';
        } else {
            return $this->context->link->getPageLink(
                'contact-form.php',
                true,
                Configuration::get('PS_LANG_DEFAULT')
            );
        }
    }

    public function isMultiShopContext()
    {
        if (_PS_VERSION_ < 1.5 || !Configuration::get('PS_MULTISHOP_FEATURE_ACTIVE')) {
            return false;
        }

        $shop_context = Shop::getContext();
        if ($shop_context == Shop::CONTEXT_ALL ||
            ((is_null($this->context->controller->multishop_context_group) ||
                    $this->context->controller->multishop_context_group == false) &&
                $shop_context == Shop::CONTEXT_GROUP)) {
            return false;
        }

        return true;
    }

    public function getContext()
    {
        return $this->context;
    }

    public function uninstall()
    {
        if (!parent::uninstall()) {
            return false;
        }

        return true;
    }

    public function getCustomerLocale($id_customer)
    {
        if (_PS_VERSION_ < '1.5.4') {
            $query = 'SELECT c.`iso_code`, SUBSTRING(d.`accept_language`,1,2) AS `iso_code2`,
                `country`.`iso_code` as `country_code`
            FROM `'._DB_PREFIX_.'customer` a
            LEFT JOIN `'._DB_PREFIX_.'address` AS `address` ON (`address`.`id_customer` = `a`.`id_customer`)
            LEFT JOIN `'._DB_PREFIX_.'country` AS `country` ON (`address`.`id_country` = `country`.`id_country`)
            LEFT JOIN `'._DB_PREFIX_.'cart` b ON (a.`id_customer` = b.`id_customer`)
            LEFT JOIN `'._DB_PREFIX_.'lang` c ON (b.`id_lang` = c.`id_lang`)
            LEFT JOIN `'._DB_PREFIX_.'guest` d ON (a.`id_customer` = d.`id_customer`)
            WHERE a.`id_customer` = '.(int)$id_customer.'';
        } else {
            $query = 'SELECT b.`iso_code`, `country`.`iso_code` as `country_code`
            FROM `'._DB_PREFIX_.'customer` a
            LEFT JOIN `'._DB_PREFIX_.'address` AS `address` ON (`address`.`id_customer` = `a`.`id_customer`)
            LEFT JOIN `'._DB_PREFIX_.'country` AS `country` ON (`address`.`id_country` = `country`.`id_country`)
            LEFT JOIN `'._DB_PREFIX_.'lang` b ON (a.`id_lang` = b.`id_lang`)
            WHERE a.`id_customer` = '.(int)$id_customer.'';
        }
        $row = Db::getInstance(_PS_USE_SQL_SLAVE_)->getRow($query);

        return self::getLocaleFromSqlRow($row);
    }

    public static function getLocaleFromSqlRow($row)
    {
        if (array_key_exists('iso_code', $row) && $row['iso_code']) {
            $lang = $row['iso_code'];
        } elseif (array_key_exists('iso_code2', $row) && $row['iso_code2']) {
            $lang = $row['iso_code2'];
        } else {
            $lang = Language::getIsoById(Configuration::get('PS_LANG_DEFAULT'));
        }

        if (array_key_exists('country_code', $row) && $row['country_code']) {
            $country = $row['country_code'];
        } else {
            $country = Country::getIsoById(Configuration::get('PS_COUNTRY_DEFAULT'));
        }

        return Tools::strtolower($lang).'_'.Tools::strtoupper($country);
    }

    public function hookDisplayFooter($params)
    {
        return $this->hookFooter($params);
    }

    public function hookFooter($params)
    {
        if (!$this->scriptDisplayed) {
            try {
                $SHOPIMIND_CLIENT_CONFIGURATION = require _PS_MODULE_DIR_.$this->name.
                    '/ShopimindClient/src/definitions.php';
            } catch (Exception $e) {
            }

            $spm_user_infos = $this->getCurrentUserInfos(true);
            $spm_user_infos_encode = $this->__httpBuildQuery($this->getCurrentUserInfos());
            $spm_user_infos = $this->jsonEncode($spm_user_infos);
            $spm_client_url = htmlentities(
                @$SHOPIMIND_CLIENT_CONFIGURATION['api']['script_url'],
                ENT_COMPAT,
                'UTF-8'
            );

            if (Configuration::get('SPM_SCRIPT_URL') && Configuration::get('SPM_SCRIPT_URL') != "") {
                $spm_client_url = htmlentities(
                    Configuration::get('SPM_SCRIPT_URL'),
                    ENT_COMPAT,
                    'UTF-8'
                );
            }


            $this->context->smarty->assign(array(
                'spm_client_url' => $spm_client_url,
                'spm_user_infos' => $spm_user_infos,
                'spm_user_infos_encode' => $spm_user_infos_encode,
            ));

            if ((int)Configuration::get('SPM_cacheWorkaround')) {
                if (_PS_VERSION_ < 1.5) {
                    $spm_ajaxspmq_url = __PS_BASE_URI__.'modules/'.$this->name.'/ajaxspmq.php';
                } else {
                    $spm_ajaxspmq_url = $this->context->link->getModuleLink($this->name, 'ajaxspmq', [], true);
                }
                $this->context->smarty->assign('spm_ajaxspmq_url', $spm_ajaxspmq_url);
                if (version_compare(_PS_VERSION_, '1.6.1.0', '<')) {
                    $tpl = $this->display(__FILE__, 'views/templates/front/spm_tag_cacheworkaround_old.tpl');
                } else {
                    $tpl = $this->display(__FILE__, 'views/templates/front/spm_tag_cacheworkaround.tpl');
                }
            } else {
                if (version_compare(_PS_VERSION_, '1.6.1.0', '<')) {
                    $tpl = $this->display(__FILE__, 'views/templates/front/spm_tag_old.tpl');
                } else {
                    $tpl = $this->display(__FILE__, 'views/templates/front/spm_tag.tpl');
                }
            }

            if (!is_null(Tools::getValue('shpmid_cart_id')) && !is_null(Tools::getValue('shpmid_cart_secret'))) {
                // On récupère le panier en fonction de l'ID passé en paramètre
                $cart = new Cart(Tools::getValue('shpmid_cart_id'));

                $token_string = $cart->id_customer.'-'.$cart->id.'-'.$cart->date_add;
                $token = md5($token_string.'-'.sha1(Configuration::get('SPM_apiPassword')));

                if ($token === Tools::getValue('shpmid_cart_secret')) {
                    // Le token est bon, on identifie l'utilisateur, et on le redirige vers son panier
                    $customer = new Customer($cart->id_customer);

                    if (property_exists($this->context->cookie, 'id_compare') &&
                        $this->context->cookie->id_compare) {
                        $id_compare = $this->context->cookie->id_compare;
                    } elseif (class_exists('CompareProduct')) {
                        $id_compare = CompareProduct::getIdCompareByIdCustomer($customer->id);
                    } else {
                        $id_compare = null;
                    }

                    $this->context->cookie->id_compare = $id_compare;
                    $this->context->cookie->id_customer = (int)($customer->id);
                    $this->context->cookie->customer_lastname = $customer->lastname;
                    $this->context->cookie->customer_firstname = $customer->firstname;
                    $this->context->cookie->logged = 1;
                    $customer->logged = 1;
                    $this->context->cookie->is_guest = $customer->isGuest();
                    $this->context->cookie->passwd = $customer->passwd;
                    $this->context->cookie->email = $customer->email;
                    $this->context->customer = $customer;

                    $this->context->cart = new Cart($cart->id);
                    $this->context->cart->id_customer = (int)$customer->id;
                    $this->context->cart->secure_key = $customer->secure_key;
                    $this->context->cart->save();
                    $this->context->cookie->id_cart = (int)$this->context->cart->id;
                    $this->context->cookie->write();
                    Tools::redirect('index.php?controller=cart&action=show');
                }
            }

            $this->scriptDisplayed = true;

            return $tpl;
        }
    }

    public function getCurrentUserCustomerInfos($callFromCacheWorkaround = false)
    {
        $currentUserInfos = array();
        if (!$callFromCacheWorkaround && (int)Configuration::get('SPM_cacheWorkaround')) {
            return $currentUserInfos;
        }
        if ($this->isLogged()) {
            $currentUserInfos['user'] = array(
                'id_customer' => htmlentities(
                    $this->context->customer->id,
                    ENT_COMPAT,
                    'UTF-8'
                )
            );
        } else {
            $currentUserInfos['user'] = null;
        }
        return $currentUserInfos;
    }

    public function getCurrentUserCartInfos($callFromCacheWorkaround = false,$full = false)
    {
        $currentUserInfos = array();
        if (!$callFromCacheWorkaround && (int)Configuration::get('SPM_cacheWorkaround')) {
            return $currentUserInfos;
        }
        // Id du panier
        if (property_exists($this->context, 'cart') &&
            property_exists($this->context->cart, 'id') &&
            $this->context->cart->id) {
            include_once(_PS_MODULE_DIR_.$this->name.'/ShopimindClient/callback.php');
            $currentUserInfos['id_cart'] = htmlentities(
                $this->context->cart->id,
                ENT_COMPAT,
                'UTF-8'
            );
            if ($full) {
                $currency = new Currency($this->context->cart->id_currency);

                $vouchers = ShopimindClientCallback::getCartVouchers();
                if (is_array($vouchers) && count($vouchers)) {
                    $vouchers = array_map('htmlentities', $vouchers);
                } else {
                    $vouchers = null;
                }

                $currentUserInfos['cart']['id_customer'] = htmlentities(
                    $this->context->cart->id_customer,
                    ENT_COMPAT,
                    'UTF-8'
                );
                $currentUserInfos['cart']['id_cart'] = htmlentities(
                    $this->context->cart->id,
                    ENT_COMPAT,
                    'UTF-8'
                );
                $currentUserInfos['cart']['date_add'] = htmlentities(
                    $this->context->cart->date_add,
                    ENT_COMPAT,
                    'UTF-8'
                );
                $currentUserInfos['cart']['date_upd'] = htmlentities(
                    $this->context->cart->date_upd,
                    ENT_COMPAT,
                    'UTF-8'
                );
                $currentUserInfos['cart']['amount'] = htmlentities(
                    $this->context->cart->getOrderTotal(true, Cart::BOTH_WITHOUT_SHIPPING),
                    ENT_COMPAT,
                    'UTF-8'
                );
                $currentUserInfos['cart']['tax_rate'] = htmlentities(
                    $currency->conversion_rate,
                    ENT_COMPAT,
                    'UTF-8'
                );
                $currentUserInfos['cart']['currency'] = htmlentities(
                    $currency->iso_code,
                    ENT_COMPAT,
                    'UTF-8'
                );
                $currentUserInfos['cart']['voucher_used'] = $vouchers;
                $currentUserInfos['cart']['voucher_amount'] = htmlentities(
                    abs($this->context->cart->getOrderTotal(true, Cart::ONLY_DISCOUNTS)),
                    ENT_COMPAT,
                    'UTF-8'
                );

                $cartProducts = $this->context->cart->getProducts();

                if (is_array($cartProducts) && count($cartProducts)) {
                    foreach ($cartProducts as $product) {
                        $currentUserInfos['cart']['products'][] = array(
                            'id_product' => htmlentities(
                                $product['id_product'],
                                ENT_COMPAT,
                                'UTF-8'
                            ),
                            'id_combination' => htmlentities(
                                $product['id_product_attribute'],
                                ENT_COMPAT,
                                'UTF-8'
                            ),
                            'id_manufacturer' => htmlentities(
                                $product['id_manufacturer'],
                                ENT_COMPAT,
                                'UTF-8'
                            ),
                            'qty' => htmlentities(
                                $product['cart_quantity'],
                                ENT_COMPAT,
                                'UTF-8'
                            ),
                            'price' => htmlentities(
                                Tax::excludeTaxeOption() ? $product['price_wt'] : $product['price'],
                                ENT_COMPAT,
                                'UTF-8'
                            ),
                            'price_without_tax' => htmlentities(
                                $product['price_wt'],
                                ENT_COMPAT,
                                'UTF-8'
                            ),
                        );
                    }
                } else {
                    $currentUserInfos['cart']['products'] = null;
                }
            }
        } else {
            $currentUserInfos['id_cart'] = null;
        }
        return $currentUserInfos;
    }

    public function getCurrentUserInfosCacheWorkaround($full = false)
    {
        $currentUserInfos = array();
        //Get user infos
        $currentUserInfos = array_merge_recursive($currentUserInfos, $this->getCurrentUserCustomerInfos(true));
        //Get Cart infos
        $currentUserInfos = array_merge_recursive($currentUserInfos, $this->getCurrentUserCartInfos(true,$full));
        return $currentUserInfos;
    }

    public function getCurrentUserInfos($full = false)
    {
        $currentUserInfos = array();

        $url = '//'.$_SERVER['HTTP_HOST'].$_SERVER['REQUEST_URI'];
        $currentUserInfos['url'] = htmlspecialchars($url, ENT_QUOTES, 'UTF-8');

        $currentUserInfos = array_merge_recursive($currentUserInfos, $this->getCurrentUserCustomerInfos());

        $currentUserInfos['id_product'] = htmlentities(
            Tools::getValue('id_product'),
            ENT_COMPAT,
            'UTF-8'
        );
        $currentUserInfos['id_category'] = htmlentities(
            Tools::getValue('id_category'),
            ENT_COMPAT,
            'UTF-8'
        );
        $currentUserInfos['id_manufacturer'] = htmlentities(
            Tools::getValue('id_manufacturer'),
            ENT_COMPAT,
            'UTF-8'
        );
        $currentUserInfos['spm_ident'] = htmlentities(
            Configuration::get('SPM_apiIdentification'),
            ENT_COMPAT,
            'UTF-8'
        );

        $currentUserInfos = array_merge_recursive($currentUserInfos, $this->getCurrentUserCartInfos(false,$full));

        if (Tools::getIsset('id_cart') && Tools::getIsset('id_order')) {
            $currentUserInfos['confirm_cart_to_order'] = Tools::getValue('id_cart').';'.Tools::getValue('id_order');
        }

        return $currentUserInfos;
    }

    public function isLogged()
    {
        if (_PS_VERSION_ < 1.5) {
            $isLogged = (property_exists($this->context, 'customer') &&
                property_exists($this->context->customer, 'id') &&
                $this->context->customer->id);
        } else {
            $isLogged = @$this->context->customer->isLogged();
        }

        return $isLogged;
    }

    public function __httpBuildQuery(
        $data,
        $prefix = null,
        $sep = null,
        $key = '',
        $urlencode = true
    ) {
        if (!function_exists('http_build_query')) {
            $ret = array();

            foreach ((array)$data as $k => $v) {
                if ($urlencode) {
                    $k = urlencode($k);
                }
                if (is_int($k) && $prefix != null) {
                    $k = $prefix.$k;
                }
                if (!empty($key)) {
                    $k = $key.'%5B'.$k.'%5D';
                }
                if ($v === null) {
                    continue;
                } elseif ($v === false) {
                    $v = '0';
                }

                if (is_array($v) || is_object($v)) {
                    array_push($ret, $this->__httpBuildQuery($v, '', $sep, $k, $urlencode));
                } elseif ($urlencode) {
                    array_push($ret, $k.'='.urlencode($v));
                } else {
                    array_push($ret, $k.'='.$v);
                }
            }

            if (null === $sep) {
                $sep = ini_get('arg_separator.output');
            }

            return implode($sep, $ret);
        } else {
            return http_build_query($data);
        }
    }

    public function jsonEncode($a)
    {
        if (!function_exists('json_encode')) {
            if (is_null($a)) {
                return 'null';
            }
            if ($a === false) {
                return 'false';
            }
            if ($a === true) {
                return 'true';
            }
            if (is_scalar($a)) {
                if (is_float($a)) {
                    // Always use "." for floats.
                    return (float)(str_replace(",", ".", (string)($a)));
                }

                if (is_string($a)) {
                    static $jsonReplaces = array(
                        array(
                            "\\",
                            "/",
                            "\n",
                            "\t",
                            "\r",
                            "\b",
                            "\f",
                            '"',
                        ),
                        array(
                            '\\\\',
                            '\\/',
                            '\\n',
                            '\\t',
                            '\\r',
                            '\\b',
                            '\\f',
                            '\"',
                        ),
                    );

                    return '"'.str_replace($jsonReplaces[0], $jsonReplaces[1], $a).'"';
                } else {
                    return $a;
                }
            }
            $isList = true;
            for ($i = 0, reset($a); $i < count($a); $i++, next($a)) {
                if (key($a) !== $i) {
                    $isList = false;
                    break;
                }
            }
            $result = array();
            if ($isList) {
                foreach ($a as $v) {
                    $result[] = Tools::jsonEncode($v);
                }

                return '['.join(',', $result).']';
            } else {
                foreach ($a as $k => $v) {
                    $result[] = Tools::jsonEncode($k).':'.Tools::jsonEncode($v);
                }

                return '{'.join(',', $result).'}';
            }
        } else {
            return Tools::jsonEncode($a);
        }
    }

    public function getApiClientUrl()
    {
        try {
            $SHOPIMIND_CLIENT_CONFIGURATION = require _PS_MODULE_DIR_.$this->name.
                '/ShopimindClient/src/definitions.php';
        } catch (Exception $e) {
        }

        return @$SHOPIMIND_CLIENT_CONFIGURATION['api']['public_url'];
    }

    public function hookDisplayOrderConfirmation($params)
    {
        if (array_key_exists('objOrder', $params)) {
            $order = $params['objOrder'];

            if (Validate::isLoadedObject($order)) {
                $this->confirm_cart_to_order = $order->id_cart.';'.$order->id;
            }
        } elseif (array_key_exists('order', $params)) {
            $order = $params['order'];

            if (property_exists($order, 'id_cart') &&
                property_exists($order, 'id') &&
                $order->id_cart != '' && $order->id != '') {
                $this->confirm_cart_to_order = $order->id_cart.';'.$order->id;
            }
        }
    }

    public function hookDisplayHeader($params)
    {
        return $this->hookHeader($params);
    }

    public function hookHeader($params)
    {
        if ($this->isLogged() && (Tools::isSubmit('submitIdentity') || Tools::isSubmit('submitAddress'))) {
            if (file_exists(_PS_MODULE_DIR_.$this->name.'/ShopimindClient/callback.php')) {
                try {
                    if (Configuration::get('SPM_realtimeSync')) {
                        if (function_exists('curl_init')) {
                            $this->getWithoutWait('saveCustomer', array('id' => $this->context->customer->id));
                        } else {
                            include_once(_PS_MODULE_DIR_.$this->name.'/ShopimindClient/callback.php');
                            ShopimindClientCallback::saveCustomer($this->context->customer->id);
                        }
                    }
                } catch (Exception $e) {
                }
            }
        }


        if (!$this->scriptDisplayed) {
            try {
                $SHOPIMIND_CLIENT_CONFIGURATION = require _PS_MODULE_DIR_.$this->name.
                    '/ShopimindClient/src/definitions.php';
            } catch (Exception $e) {
            }

            $spm_user_infos = $this->getCurrentUserInfos(true);
            $spm_user_infos_encode = $this->__httpBuildQuery($this->getCurrentUserInfos());
            $spm_user_infos = $this->jsonEncode($spm_user_infos);
            $spm_client_url = htmlentities(
                @$SHOPIMIND_CLIENT_CONFIGURATION['api']['script_url'],
                ENT_COMPAT,
                'UTF-8'
            );

            if (Configuration::get('SPM_SCRIPT_URL') && Configuration::get('SPM_SCRIPT_URL') != "") {
                $spm_client_url = htmlentities(
                    Configuration::get('SPM_SCRIPT_URL'),
                    ENT_COMPAT,
                    'UTF-8'
                );
            }
            $this->context->smarty->assign(array(
                'spm_client_url' => $spm_client_url,
                'spm_user_infos' => $spm_user_infos,
                'spm_user_infos_encode' => $spm_user_infos_encode,
            ));

            if ((int)Configuration::get('SPM_cacheWorkaround')) {
                if (_PS_VERSION_ < 1.5) {
                    $spm_ajaxspmq_url = __PS_BASE_URI__.'modules/'.$this->name.'/ajaxspmq.php';
                } else {
                    $spm_ajaxspmq_url = $this->context->link->getModuleLink($this->name, 'ajaxspmq', [], true);
                }
                $this->context->smarty->assign('spm_ajaxspmq_url', $spm_ajaxspmq_url);
                if (version_compare(_PS_VERSION_, '1.6.1.0', '<')) {
                    $tpl = $this->display(__FILE__, 'views/templates/front/spm_tag_cacheworkaround_old.tpl');
                } else {
                    $tpl = $this->display(__FILE__, 'views/templates/front/spm_tag_cacheworkaround.tpl');
                }

            } else {
                if (version_compare(_PS_VERSION_, '1.6.1.0', '<')) {
                    $tpl = $this->display(__FILE__, 'views/templates/front/spm_tag_old.tpl');
                } else {
                    $tpl = $this->display(__FILE__, 'views/templates/front/spm_tag.tpl');
                }
            }

            if (!is_null(Tools::getValue('shpmid_cart_id')) && !is_null(Tools::getValue('shpmid_cart_secret')) && Tools::getValue('shpmid_cart_id') && Tools::getValue('shpmid_cart_secret')) {
                // On récupère le panier en fonction de l'ID passé en paramètre
                $cart = new Cart(Tools::getValue('shpmid_cart_id'));
                $string_token = $cart->id_customer.'-'.$cart->id.'-'.$cart->date_add;
                $token = md5($string_token.'-'.sha1(Configuration::get('SPM_apiPassword')));
                if ($token === Tools::getValue('shpmid_cart_secret')) {
                    // Le token est bon, on identifie l'utilisateur, et on le redirige vers son panier
                    $customer = new Customer($cart->id_customer);

                    if (property_exists($this->context->cookie, 'id_compare') &&
                        $this->context->cookie->id_compare) {
                        $id_compare = $this->context->cookie->id_compare;
                    } elseif (class_exists('CompareProduct')) {
                        $id_compare = CompareProduct::getIdCompareByIdCustomer($customer->id);
                    } else {
                        $id_compare = null;
                    }

                    $this->context->cookie->id_compare = $id_compare;
                    $this->context->cookie->id_customer = (int)($customer->id);
                    $this->context->cookie->customer_lastname = $customer->lastname;
                    $this->context->cookie->customer_firstname = $customer->firstname;
                    $this->context->cookie->logged = 1;
                    $customer->logged = 1;
                    $this->context->cookie->is_guest = $customer->isGuest();
                    $this->context->cookie->passwd = $customer->passwd;
                    $this->context->cookie->email = $customer->email;
                    $this->context->customer = $customer;

                    $this->context->cart = new Cart($cart->id);
                    $this->context->cart->id_customer = (int)$customer->id;
                    $this->context->cart->secure_key = $customer->secure_key;
                    $this->context->cart->save();
                    $this->context->cookie->id_cart = (int)$this->context->cart->id;
                    $this->context->cookie->write();
                    Tools::redirect('index.php?controller=cart&action=show');
                }
            }

            $this->scriptDisplayed = true;

            return $tpl;
        }
    }

    private function getWithoutWait($action, $params)
    {
        $url = Tools::getHttpHost(true).__PS_BASE_URI__;

        if (Tools::substr($url, -1) != '/') {
            $url .= '/';
        }

        $url .= str_replace(
            dirname(_PS_MODULE_DIR_).'/',
            '',
            _PS_MODULE_DIR_
        ).$this->name.'/ShopimindClient/asyncCall.php?action='.$action.'&'.http_build_query($params);

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_TIMEOUT, 1);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_exec($ch);

        curl_close($ch);
    }

    public function hookCreateAccount($params)
    {
        try {
            if ($params['newCustomer'] instanceof Customer) {
                if (property_exists($params['newCustomer'], 'id') && $params['newCustomer']->id) {
                    if (Configuration::get('SPM_realtimeSync')) {
                        if (function_exists('curl_init')) {
                            $this->getWithoutWait('saveCustomer', array('id' => $params['newCustomer']->id));
                        } else {
                            include_once(_PS_MODULE_DIR_.$this->name.'/ShopimindClient/callback.php');
                            ShopimindClientCallback::saveCustomer($params['newCustomer']->id);
                        }
                    }
                }
            }
        } catch (Exception $e) {
        }
    }

    public function hookBackOfficeHeader($params)
    {
        try {
            /**
             * Add/update Customer From Backoffice
             */
            if (Tools::getValue('tab') == 'AdminCustomers' &&
                Tools::getValue('id_customer') &&
                !Tools::getIsset('deletecustomer')) {
                if (function_exists('curl_init')) {
                    $this->getWithoutWait('saveCustomer', array('id' => Tools::getValue('id_customer')));
                } else {
                    include_once(_PS_MODULE_DIR_.$this->name.'/ShopimindClient/callback.php');
                    ShopimindClientCallback::saveCustomer(Tools::getValue('id_customer'));
                }
            }

            /**
             * Delete Customer From Backoffice
             */
            if (Tools::getIsset('deletecustomer') &&
                Tools::getIsset('deleteMode') &&
                Tools::getValue('id_customer')) {
                if (function_exists('curl_init')) {
                    $this->getWithoutWait('deleteCustomer', array('id' => Tools::getValue('id_customer')));
                } else {
                    include_once(_PS_MODULE_DIR_.$this->name.'/ShopimindClient/callback.php');
                    ShopimindClientCallback::deleteCustomer(Tools::getValue('id_customer'));
                }
            }

            /**
             * Add/update Customer Address From Backoffice
             */
            if (Tools::getValue('tab') == 'AdminAddresses' &&
                Tools::getValue('id_address') &&
                !Tools::getIsset('deleteaddress')) {
                $address = new Address(Tools::getValue('id_address'));
                if (function_exists('curl_init')) {
                    $this->getWithoutWait('saveCustomer', array('id' => $address->id_customer));
                } else {
                    include_once(_PS_MODULE_DIR_.$this->name.'/ShopimindClient/callback.php');
                    ShopimindClientCallback::saveCustomer($address->id_customer);
                }
            }
        } catch (Exception $e) {
        }
    }

    public function hookActionObjectAddAfter(array $params)
    {
        try {
            if (array_key_exists('object', $params)) {
                if ($params['object'] instanceof Product) {
                    if (Configuration::get('SPM_realtimeSync')) {
                        if (function_exists('curl_init')) {
                            $this->getWithoutWait('saveProduct', array('id' => $params['object']->id));
                        } else {
                            include_once(_PS_MODULE_DIR_.$this->name.'/ShopimindClient/callback.php');
                            ShopimindClientCallback::saveProduct($params['object']->id);
                        }
                    }
                } elseif ($params['object'] instanceof Customer) {
                    if (Configuration::get('SPM_realtimeSync')) {
                        if (function_exists('curl_init')) {
                            $this->getWithoutWait('saveCustomer', array('id' => $params['object']->id));
                        } else {
                            include_once(_PS_MODULE_DIR_.$this->name.'/ShopimindClient/callback.php');
                            ShopimindClientCallback::saveCustomer($params['object']->id);
                        }
                    }
                } elseif ($params['object'] instanceof Address) {
                    if (property_exists($params['object'], 'id_customer') && $params['object']->id_customer) {
                        if (Configuration::get('SPM_realtimeSync')) {
                            if (function_exists('curl_init')) {
                                $this->getWithoutWait('saveCustomer', array('id' => $params['object']->id));
                            } else {
                                include_once(_PS_MODULE_DIR_.$this->name.'/ShopimindClient/callback.php');
                                ShopimindClientCallback::saveCustomer($params['object']->id_customer);
                            }
                        }
                    }
                } elseif ($params['object'] instanceof Category) {
                    if (Configuration::get('SPM_realtimeSync')) {
                        if (function_exists('curl_init')) {
                            $this->getWithoutWait('saveProductCategory', array('id' => $params['object']->id));
                        } else {
                            include_once(_PS_MODULE_DIR_.$this->name.'/ShopimindClient/callback.php');
                            ShopimindClientCallback::saveProductCategory($params['object']->id);
                        }
                    }
                } elseif ($params['object'] instanceof Group) {
                    if (Configuration::get('SPM_realtimeSync')) {
                        if (function_exists('curl_init')) {
                            $this->getWithoutWait('saveCustomerGroup', array('id' => $params['object']->id));
                        } else {
                            include_once(_PS_MODULE_DIR_.$this->name.'/ShopimindClient/callback.php');
                            ShopimindClientCallback::saveCustomerGroup($params['object']->id);
                        }
                    }
                } elseif ($params['object'] instanceof Manufacturer) {
                    if (Configuration::get('SPM_realtimeSync')) {
                        if (function_exists('curl_init')) {
                            $this->getWithoutWait('saveManufacturer', array('id' => $params['object']->id));
                        } else {
                            include_once(_PS_MODULE_DIR_.$this->name.'/ShopimindClient/callback.php');
                            ShopimindClientCallback::saveManufacturer($params['object']->id);
                        }
                    }
                } elseif ($params['object'] instanceof Carrier) {
                    if (Configuration::get('SPM_realtimeSync')) {
                        if (function_exists('curl_init')) {
                            $this->getWithoutWait('saveCarrier', array('id' => $params['object']->id));
                        } else {
                            include_once(_PS_MODULE_DIR_.$this->name.'/ShopimindClient/callback.php');
                            ShopimindClientCallback::saveCarrier($params['object']->id);
                        }
                    }
                }
            }
        } catch (Exception $e) {
        }
    }

    public function hookActionObjectUpdateAfter(array $params)
    {
        try {
            if (array_key_exists('object', $params)) {
                if ($params['object'] instanceof Product) {
                    if (Configuration::get('SPM_realtimeSync')) {
                        if (function_exists('curl_init')) {
                            $this->getWithoutWait('saveProduct', array('id' => $params['object']->id));
                        } else {
                            include_once(_PS_MODULE_DIR_.$this->name.'/ShopimindClient/callback.php');
                            ShopimindClientCallback::saveProduct($params['object']->id);
                        }
                    }
                } elseif ($params['object'] instanceof Customer) {
                    if (Configuration::get('SPM_realtimeSync')) {
                        if (function_exists('curl_init')) {
                            $this->getWithoutWait('saveCustomer', array('id' => $params['object']->id));
                        } else {
                            include_once(_PS_MODULE_DIR_.$this->name.'/ShopimindClient/callback.php');
                            ShopimindClientCallback::saveCustomer($params['object']->id);
                        }
                    }
                } elseif ($params['object'] instanceof Category) {
                    if (Configuration::get('SPM_realtimeSync')) {
                        if (function_exists('curl_init')) {
                            $this->getWithoutWait('saveProductCategory', array('id' => $params['object']->id));
                        } else {
                            include_once(_PS_MODULE_DIR_.$this->name.'/ShopimindClient/callback.php');
                            ShopimindClientCallback::saveProductCategory($params['object']->id);
                        }
                    }
                } elseif ($params['object'] instanceof Group) {
                    if (Configuration::get('SPM_realtimeSync')) {
                        if (function_exists('curl_init')) {
                            $this->getWithoutWait('saveCustomerGroup', array('id' => $params['object']->id));
                        } else {
                            include_once(_PS_MODULE_DIR_.$this->name.'/ShopimindClient/callback.php');
                            ShopimindClientCallback::saveCustomerGroup($params['object']->id);
                        }
                    }
                } elseif ($params['object'] instanceof Manufacturer) {
                    if (Configuration::get('SPM_realtimeSync')) {
                        if (function_exists('curl_init')) {
                            $this->getWithoutWait('saveManufacturer', array('id' => $params['object']->id));
                        } else {
                            include_once(_PS_MODULE_DIR_.$this->name.'/ShopimindClient/callback.php');
                            ShopimindClientCallback::saveManufacturer($params['object']->id);
                        }
                    }
                } elseif ($params['object'] instanceof Carrier) {
                    if (Configuration::get('SPM_realtimeSync')) {
                        if (function_exists('curl_init')) {
                            $this->getWithoutWait('saveCarrier', array('id' => $params['object']->id));
                        } else {
                            include_once(_PS_MODULE_DIR_.$this->name.'/ShopimindClient/callback.php');
                            ShopimindClientCallback::saveCarrier($params['object']->id);
                        }
                    }
                }
            }
        } catch (Exception $e) {
        }
    }

    public function hookActionObjectDeleteAfter(array $params)
    {
        try {
            if (array_key_exists('object', $params)) {
                if ($params['object'] instanceof Product) {
                    if (function_exists('curl_init')) {
                        $this->getWithoutWait('deleteProduct', array('id' => $params['object']->id));
                    } else {
                        include_once(_PS_MODULE_DIR_.$this->name.'/ShopimindClient/callback.php');
                        ShopimindClientCallback::deleteProduct($params['object']->id);
                    }
                } elseif ($params['object'] instanceof Customer) {
                    if (function_exists('curl_init')) {
                        $this->getWithoutWait('deleteCustomer', array('id' => $params['object']->id));
                    } else {
                        include_once(_PS_MODULE_DIR_.$this->name.'/ShopimindClient/callback.php');
                        ShopimindClientCallback::deleteCustomer($params['object']->id);
                    }
                } elseif ($params['object'] instanceof Category) {
                    if (function_exists('curl_init')) {
                        $this->getWithoutWait('deleteProductCategory', array('id' => $params['object']->id));
                    } else {
                        include_once(_PS_MODULE_DIR_.$this->name.'/ShopimindClient/callback.php');
                        ShopimindClientCallback::deleteProductCategory($params['object']->id);
                    }
                } elseif ($params['object'] instanceof Group) {
                    if (function_exists('curl_init')) {
                        $this->getWithoutWait('deleteCustomerGroup', array('id' => $params['object']->id));
                    } else {
                        include_once(_PS_MODULE_DIR_.$this->name.'/ShopimindClient/callback.php');
                        ShopimindClientCallback::deleteCustomerGroup($params['object']->id);
                    }
                } elseif ($params['object'] instanceof Manufacturer) {
                    if (function_exists('curl_init')) {
                        $this->getWithoutWait('deleteManufacturer', array('id' => $params['object']->id));
                    } else {
                        include_once(_PS_MODULE_DIR_.$this->name.'/ShopimindClient/callback.php');
                        ShopimindClientCallback::deleteManufacturer($params['object']->id);
                    }
                } elseif ($params['object'] instanceof Carrier) {
                    if (function_exists('curl_init')) {
                        $this->getWithoutWait('deleteCarrier', array('id' => $params['object']->id));
                    } else {
                        include_once(_PS_MODULE_DIR_.$this->name.'/ShopimindClient/callback.php');
                        ShopimindClientCallback::deleteCarrier($params['object']->id);
                    }
                }
            }
        } catch (Exception $e) {
        }
    }

    public function hookActionOrderStatusUpdate($params)
    {
        return $this->hookUpdateOrderStatus($params);
    }

    public function hookUpdateOrderStatus($params)
    {
        $order = new Order((int)($params['id_order']));

        if ($order && !Validate::isLoadedObject($order)) {
            return;
        }
        //On vérifie que la commande n'est pas trop ancienne
        $date = new DateTime();
        $date->sub(new DateInterval('P3M'));
        if ($date->format('Y-m-d H:i:s') > $order->date_add) {
            return;
        }
        try {
            if (Configuration::get('SPM_realtimeSync')) {
                if (function_exists('curl_init')) {
                    $this->getWithoutWait('saveOrder', array('id' => $order->id));
                } else {
                    include_once(_PS_MODULE_DIR_.$this->name.'/ShopimindClient/callback.php');
                    ShopimindClientCallback::saveOrder($order->id);
                }
            } else {
                /* Si la synchro temps réel est désactivée par l'admin,
                on ne synchronise en temps réel que les dernières commandes (-48h) */
                $date = new DateTime();
                $date->sub(new DateInterval('P2D'));
                if ($date->format('Y-m-d H:i:s') <= $order->date_add) {
                    if (function_exists('curl_init')) {
                        $this->getWithoutWait('saveOrder', array('id' => $order->id));
                    } else {
                        include_once(_PS_MODULE_DIR_.$this->name.'/ShopimindClient/callback.php');
                        ShopimindClientCallback::saveOrder($order->id);
                    }
                }
            }
        } catch (Exception $e) {
        }
    }

    public function hookUpdateProduct(array $params)
    {
        $this->hookAddProduct($params);
    }

    public function hookAddProduct(array $params)
    {
        try {
            if ($params['product'] instanceof Product) {
                if (Configuration::get('SPM_realtimeSync')) {
                    if (function_exists('curl_init')) {
                        $this->getWithoutWait('saveProduct', array('id' => $params['product']->id));
                    } else {
                        include_once(_PS_MODULE_DIR_.$this->name.'/ShopimindClient/callback.php');
                        ShopimindClientCallback::saveProduct($params['product']->id);
                    }
                }
            }
        } catch (Exception $e) {
        }
    }

    public function hookdeleteProduct(array $params)
    {
        try {
            if ($params['product'] instanceof Product) {
                if (function_exists('curl_init')) {
                    $this->getWithoutWait('deleteProduct', array('id' => $params['product']->id));
                } else {
                    include_once(_PS_MODULE_DIR_.$this->name.'/ShopimindClient/callback.php');
                    ShopimindClientCallback::deleteProduct($params['product']->id);
                }
            }
        } catch (Exception $e) {
        }
    }

    public function hookCategoryUpdate(array $params)
    {
        $this->hookCategoryAddition($params);
    }

    public function hookCategoryAddition(array $params)
    {
        try {
            if ($params['category'] instanceof Category) {
                if (Configuration::get('SPM_realtimeSync')) {
                    if (function_exists('curl_init')) {
                        $this->getWithoutWait('saveProductCategory', array('id' => $params['category']->id));
                    } else {
                        include_once(_PS_MODULE_DIR_.$this->name.'/ShopimindClient/callback.php');
                        ShopimindClientCallback::saveProductCategory($params['category']->id);
                    }
                }
            }
        } catch (Exception $e) {
        }
    }

    public function hookCategoryDeletion(array $params)
    {
        try {
            if ($params['category'] instanceof Category) {
                if (function_exists('curl_init')) {
                    $this->getWithoutWait('deleteProductCategory', array('id' => $params['category']->id));
                } else {
                    include_once(_PS_MODULE_DIR_.$this->name.'/ShopimindClient/callback.php');
                    ShopimindClientCallback::deleteProductCategory($params['category']->id);
                }
            }
        } catch (Exception $e) {
        }
    }

    protected function getProductImageSizes()
    {
        $results = Db::getInstance(_PS_USE_SQL_SLAVE_)->executeS('
        SELECT `name`, `width`, `height`
        FROM `'._DB_PREFIX_.'image_type`
        WHERE `products` = 1
        ORDER BY `width` ASC');
        $return = array();

        if ($results && is_array($results) && sizeof($results)) {
            foreach ($results as $row) {
                $return[$row['name']] = $row['name'].' ('.$row['width'].' * '.$row['height'].')';
            }
        }

        return $return;
    }

    public function getContent()
    {
        $output = null;

        if (Tools::isSubmit('submitShopimind')) {
            $apiIdentification = Tools::getValue('apiIdentification');
            $apiPassword = Tools::getValue('apiPassword');
            $voucherNominative = (int)Tools::getValue('voucherNominative');
            $voucherHighlight = (int)Tools::getValue('voucherHighlight');
            $excludeOutOfStockProducts = (int)Tools::getValue('excludeOutOfStockProducts');
            $realtimeSync = (int)Tools::getValue('realtimeSync');
            $cacheWorkaround = (int)Tools::getValue('cacheWorkaround');

            $syncNL = (int)Tools::getValue('syncNL');
            $syncNLTable = Tools::getValue('syncNL_table');
            $syncNLFields = Tools::getValue('syncNL_fields');
            $just_activate = false; // Pour version PS inférieur à 1.5

            $oldApiIdentification = Configuration::get('SPM_apiIdentification');
            $oldApiPassword = Configuration::get('SPM_apiPassword');

            $fields = array();
            if (is_array($syncNLFields) && count($syncNLFields) > 0) {
                foreach ($syncNLFields as $syncField) {
                    if ($syncField != '' && $syncField) {
                        array_push($fields, $syncField);
                    }
                }
            }

            if (!$syncNLTable) {
                $syncNL = 0;
            }

            $fields = implode('|', $fields);

            if (_PS_VERSION_ < '1.5') {
                $voucherCumulablePromo = (int)Tools::getValue('voucherCumulablePromo');
            }
            $voucherCumulableVoucher = (int)Tools::getValue('voucherCumulableVoucher');

            Configuration::updateValue('SPM_apiIdentification', html_entity_decode(
                $apiIdentification,
                ENT_COMPAT,
                'UTF-8'
            ));
            Configuration::updateValue('SPM_apiPassword', html_entity_decode(
                $apiPassword,
                ENT_COMPAT,
                'UTF-8'
            ));

            Configuration::updateValue('SPM_excludeOutOfStockProducts', $excludeOutOfStockProducts);

            Configuration::updateValue('SPM_voucherNominative', $voucherNominative);

            if (_PS_VERSION_ >= '1.4') {
                Configuration::updateValue('SPM_voucherHighlight', $voucherHighlight);
            }

            if (_PS_VERSION_ < '1.5') {
                Configuration::updateValue('SPM_voucherCumulablePromo', $voucherCumulablePromo);
            }

            Configuration::updateValue('SPM_voucherCumulableVoucher', $voucherCumulableVoucher);
            Configuration::updateValue('SPM_realtimeSync', $realtimeSync);
            Configuration::updateValue('SPM_cacheWorkaround', $cacheWorkaround);
            Configuration::updateValue('SPM_syncNL', $syncNL);
            Configuration::updateValue('SPM_syncNL_table', $syncNLTable);
            Configuration::updateValue('SPM_syncNL_table_fields', $fields);
            Configuration::updateValue('SPM_productImageSize', Tools::getValue('productImageSize'));

            if (Tools::getValue('just_activate') == 1 && _PS_VERSION_ < '1.6') {
                $just_activate = true;
            }

            $response = $this->connectShopToSPM(
                $oldApiIdentification,
                $oldApiPassword,
                $apiIdentification,
                $apiPassword,
                $just_activate
            );
            $apiIdentification = Configuration::get('SPM_apiIdentification');

            if ($response['success'] && $apiIdentification) {
                $output .= $this->displayConfirmation($response['message']);
            } else {
                $output .= $this->displayError($response['message']);

                return $output.$this->getConfigPage(true).
                    $this->getConfigForm(false).
                    $this->getRegisterForm(true);
            }
        } elseif (Tools::isSubmit('submitRegisterShopimind')) {
            try {
                $SHOPIMIND_CLIENT_CONFIGURATION = require _PS_MODULE_DIR_.$this->name.
                    '/ShopimindClient/src/definitions.php';
            } catch (Exception $e) {
            }

            if (Tools::getValue('spm_promo_code') && Tools::getValue('spm_promo_code') != '') {
                $promo_code_used = htmlentities(
                    Tools::getValue('spm_promo_code'),
                    ENT_COMPAT,
                    'UTF-8'
                );
            } else {
                $promo_code_used = htmlentities(
                    @$SHOPIMIND_CLIENT_CONFIGURATION['promo_code'],
                    ENT_COMPAT,
                    'UTF-8'
                );
            }

            $data = array(
                'shop' => array(
                    'user' => array(
                        'email' => Tools::getValue('spm_register_email'),
                        'password' => Tools::getValue('spm_register_password'),
                        'passwordConfirm' => Tools::getValue('spm_register_passwordConfirm'),
                        'firstName' => Tools::getValue('spm_register_firstName'),
                        'lastName' => Tools::getValue('spm_register_lastName'),
                        'societe' => Tools::getValue('spm_register_societe'),
                        'vat_number' => Tools::getValue('spm_register_vat_number'),
                        'phoneFixe' => Tools::getValue('spm_register_phoneFixe'),
                        'phoneMobile' => Tools::getValue('spm_register_phoneMobile'),
                        'rue' => Tools::getValue('spm_register_rue'),
                        'complement' => Tools::getValue('spm_register_complement'),
                        'bp' => Tools::getValue('spm_register_bp'),
                        'lang' => Configuration::get('PS_LOCALE_LANGUAGE') ? Configuration::get('PS_LOCALE_LANGUAGE') : 'fr',
                        'zipCode' => Tools::getValue('spm_register_zipCode'),
                        'city' => Tools::getValue('spm_register_city'),
                        'country' => Tools::getValue('spm_register_country'),
                        'promoCode' => $promo_code_used,
                    ),
                    'url' => Tools::getValue('spm_register_url'),
                    'solutionEcommerce' => 'prestashop'
                ),
            );

            $body = http_build_query($data, '', '&');

            $curl = curl_init();
            curl_setopt_array($curl, array(
                CURLOPT_URL => @$SHOPIMIND_CLIENT_CONFIGURATION['api']['register_action_url'],
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => "",
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 30,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => "POST",
                CURLOPT_POSTFIELDS => $body,
                CURLOPT_HTTPHEADER => array(
                    "content-type: application/x-www-form-urlencoded; charset=UTF-8",
                    "Accept: application/json, text/javascript, */*; q=0.01",
                    "Accept-Encoding: gzip, deflate, br",
                ),
            ));
            $response = curl_exec($curl);
            curl_close($curl);

            $response = json_decode($response, true);
            if ($response && is_array($response) && array_key_exists('success', $response) && $response['success']
                && array_key_exists('identifiant', $response) && $response['identifiant'] != ''
                && array_key_exists('apiKey', $response) && $response['apiKey'] != '') {
                Configuration::updateValue('SPM_apiIdentification', $response['identifiant']);
                Configuration::updateValue('SPM_apiPassword', $response['apiKey']);

                $response_connect = $this->connectShopToSPM(
                    $response['identifiant'],
                    $response['apiKey'],
                    $response['identifiant'],
                    $response['apiKey'],
                    true
                );

                if ($response_connect['success']) {
                    $output .= $this->displayConfirmation($response_connect['message']);
                } else {
                    $output .= $this->displayError($response_connect['message']);
                }
                return $output.$this->getConfigPage(true).
                    $this->getConfigForm(false).
                    $this->getRegisterForm(true);
            } else {
                $messages = is_array($response) && array_key_exists('messages', $response) ?
                    $response['messages'] : false;
                if ($messages) {
                    $output .= $this->displayError($this->l('Please check the errors in the form.'));
                } else {
                    $output .= $this->displayError($this->l('An error has occurred. if the error persists, please contact customer service.'));
                }

                return $output.$this->getConfigPage(true).
                    $this->getConfigForm(true).
                    $this->getRegisterForm(false, $messages);
            }
        }

        return $output.$this->displayForm();
    }

    protected function displayForm()
    {
        $SPM_apiIdentification = Configuration::get('SPM_apiIdentification');

        if (!$SPM_apiIdentification) {
            return $this->getConfigPage(false).
                $this->getConfigForm(true).
                $this->getRegisterForm(true);
        } else {
            return $this->getConfigPage(true).
                $this->getConfigForm(false).
                $this->getRegisterForm(true);
        }
    }

    /*
     * Methodes de génération de formulaire de configuration/inscription
     */
    protected function getConfigPage($hide = false)
    {
        try {
            $SHOPIMIND_CLIENT_CONFIGURATION = require _PS_MODULE_DIR_.$this->name.
                '/ShopimindClient/src/definitions.php';
        } catch (Exception $e) {
        }

        $this->context->smarty->assign(array(
            'visibility' => $hide ? 'hide' : 'show',
            'logo_url' => $this->_path .'logo.gif',
            'logo_spm_url' => $this->_path .'/views/img/logo_spm.png',
            'support_email' => $SHOPIMIND_CLIENT_CONFIGURATION['support_email'],
        ));

        if (_PS_VERSION_ < '1.6') {
            $output = $this->display(__FILE__, 'views/templates/admin/old/init_page.tpl');
        } else {
            $output = $this->display(__FILE__, 'views/templates/admin/init_page.tpl');
        }

        return $output;
    }

    protected function getConfigForm($hide = false)
    {
        /* Si la version de prestashop est inférieur  à 1.5 => utiliser le formulaire sans helperForm class */
        if (_PS_VERSION_ < '1.6') {
            return $this->getConfigFormLower($hide);
        }

        $defaultLang = (int)Configuration::get('PS_LANG_DEFAULT');

        /* Récupérer les options du select image */
        $productImageSizes = $this->getProductImageSizes();
        $productImageSizesOptions = array(
            array(
                'id_option' => '',
                'name' => $this->l('Automatic')
            )
        );
        foreach ($productImageSizes as $k => $v) {
            $productImageSizesOptions[] = array(
                'id_option' =>  htmlentities($k, ENT_COMPAT, 'UTF-8'),
                'name' =>  htmlentities($v, ENT_COMPAT, 'UTF-8')
            );
        }

        /**
         * Permet de synchroniser les abonnés newsletter de la boutique vers une liste dans Shopimind
         */
        $results = Db::getInstance(_PS_USE_SQL_SLAVE_)->executeS('SHOW TABLES LIKE "'._DB_PREFIX_.'%"');
        $tables = array();
        if ($results && is_array($results) && sizeof($results)) {
            foreach ($results as $row) {
                $keys = array_keys($row);
                $tables[] = $row[$keys[0]];
            }
        }
        $nl_tables = array(
            array(
                'id_option' => '',
                'name' => $this->l('Choose your table')
            )
        );

        foreach ($tables as $table) {
            $nl_tables[] = array(
                'id_option' => $table,
                'name' => $table
            );
        }

        $fieldsForm = array('config' => array('form' => array()));
        $all_fields = [
            [
                'type' => 'text',
                'label' => $this->l('API login'),
                'name' => 'apiIdentification',
                'size' => 100,
                'required' => true
            ],
            [
                'type' => 'text',
                'label' => $this->l('API password'),
                'name' => 'apiPassword',
                'size' => 100,
                'required' => true
            ],
            [
                'type'      => 'switch',
                'label'     => $this->l('Use real-time synchronization'),
                'desc'      => $this->l('Does the synchronization of your data have to be done in real time?'),
                'name'      => 'realtimeSync',
                'required'  => true,
                'is_bool'   => true,
                'values'    => array(
                    array(
                        'id'    => 'realtimeSync_on',
                        'value' => 1,
                        'label' => $this->l('Enable')
                    ),
                    array(
                        'id'    => 'realtimeSync_off',
                        'value' => 0,
                        'label' => $this->l('Disable')
                    )
                ),
            ],
            [
                'type'      => 'switch',
                'label'     => $this->l('Cache workaround'),
                'desc'      => $this->l('Enable this mode if you are using a full page cache system.'),
                'name'      => 'cacheWorkaround',
                'required'  => true,
                'is_bool'   => true,
                'values'    => array(
                    array(
                        'id'    => 'cacheWorkaround_on',
                        'value' => 1,
                        'label' => $this->l('Enable')
                    ),
                    array(
                        'id'    => 'cacheWorkaround_off',
                        'value' => 0,
                        'label' => $this->l('Disable')
                    )
                ),
            ],
            [
                'type'      => 'switch',
                'label'     => $this->l('Generate nominative vouchers?'),
                'desc'      => $this->l('Must ShopiMind vouchers be associated with your customers\' accounts (this means that your customer must be logged in to use it) ?'),
                'name'      => 'voucherNominative',
                'required'  => true,
                'is_bool'   => true,
                'values'    => array(
                    array(
                        'id'    => 'voucherNominative_on',
                        'value' => 1,
                        'label' => $this->l('Enable')
                    ),
                    array(
                        'id'    => 'voucherNominative_off',
                        'value' => 0,
                        'label' => $this->l('Disable')
                    )
                ),
            ],
        ];

        if (_PS_VERSION_ >= '1.4') {
            array_push(
                $all_fields,
                [
                    'type'      => 'switch',
                    'label'     => $this->l('Show the voucher in the cart'),
                    'desc'      => $this->l('If the voucher has not yet been added to the cart, it will be displayed under the cart in the order summary.'),
                    'name'      => 'voucherHighlight',
                    'required'  => true,
                    'is_bool'   => true,
                    'values'    => array(
                        array(
                            'id'    => 'voucherHighlight_on',
                            'value' => 1,
                            'label' => $this->l('Enable')
                        ),
                        array(
                            'id'    => 'voucherHighlight_off',
                            'value' => 0,
                            'label' => $this->l('Disable')
                        )
                    ),
                ]
            );
        }

        if (_PS_VERSION_ < '1.5') {
            array_push(
                $all_fields,
                [
                    'type'      => 'switch',
                    'label'     => $this->l('Vouchers can be combined with your promotions?'),
                    'desc'      => $this->l('Should vouchers generated by ShopiMind be combined with your current promotions?'),
                    'name'      => 'voucherCumulablePromo',
                    'required'  => true,
                    'is_bool'   => true,
                    'values'    => array(
                        array(
                            'id'    => 'voucherCumulablePromo_on',
                            'value' => 1,
                            'label' => $this->l('Enable')
                        ),
                        array(
                            'id'    => 'voucherCumulablePromo_off',
                            'value' => 0,
                            'label' => $this->l('Disable')
                        )
                    ),
                ]
            );
        }

        /* Codes de réduction cumulables avec d'autres codes ? */
        array_push($all_fields, [
            'type'      => 'switch',
            'label'     => $this->l('Vouchers can be combined with other codes?'),
            'desc'      => $this->l('Should vouchers generated by ShopiMind be combined with other promotional codes?'),
            'name'      => 'voucherCumulableVoucher',
            'required'  => true,
            'is_bool'   => true,
            'values'    => array(
                array(
                    'id'    => 'voucherCumulableVoucher_on',
                    'value' => 1,
                    'label' => $this->l('Enable')
                ),
                array(
                    'id'    => 'voucherCumulableVoucher_off',
                    'value' => 0,
                    'label' => $this->l('Disable')
                )
            ),
        ]);

        array_push($all_fields, [
            'type'      => 'switch',
            'label'     => $this->l('Deactivate out-of-stock products ?'),
            'desc'      => $this->l('Would you like to define out-of-stock products as desactivated?'),
            'name'      => 'excludeOutOfStockProducts',
            'required'  => true,
            'is_bool'   => true,
            'values'    => array(
                array(
                    'id'    => 'excludeOutOfStockProducts_on',
                    'value' => 1,
                    'label' => $this->l('Enable')
                ),
                array(
                    'id'    => 'excludeOutOfStockProducts_off',
                    'value' => 0,
                    'label' => $this->l('Disable')
                )
            ),
        ]);

        /* Format d'image produit à utiliser dans mes Emails */
        array_push($all_fields, [
            'type' => 'select',
            'label' => $this->l('Product image format to use in my emails'),
            'desc' => $this->l('This is the image format that will be used in your product recalls and recommendations.'),
            'name' => 'productImageSize',
            'required' => true,
            'options' => array(
                'query' => $productImageSizesOptions,
                'id' => 'id_option',
                'name' => 'name'
            )
        ]);
        /* Synchroniser vos abonnés newsletter ? */
        array_push($all_fields, [
            'type'      => 'switch',
            'label'     => $this->l('Synchronize your newsletter subscribers?'),
            'desc'      => $this->l('If you have a newsletter registration form on your store, we can retrieve emails from a dedicated mailing list.'),
            'name'      => 'syncNL',
            'required'  => true,
            'is_bool'   => true,
            'values'    => array(
                array(
                    'id'    => 'syncNL_on',
                    'value' => 1,
                    'label' => $this->l('Enable')
                ),
                array(
                    'id'    => 'syncNL_off',
                    'value' => 0,
                    'label' => $this->l('Disable')
                )
            ),
        ]);
        /* Table à synchroniser */
        array_push($all_fields, [
            'type' => 'select',
            'label' => $this->l('Table to synchronize'),
            'desc' => $this->l('This is the table in your database where the emails from your newsletter module are collected.'),
            'name' => 'syncNL_table',
            'required' => false,
            'options' => array(
                'query' => $nl_tables,
                'id' => 'id_option',
                'name' => 'name'
            )
        ]);

        $fieldsForm['config']['form'] = [
            'legend' => [
                'image' => $this->_path . 'logo.gif',
                'title' => $this->l('Configuration of ShopiMind module'),
            ],
            'input' => $all_fields,
            'submit' => [
                'title' => $this->l('Submit'),
                'class' => 'btn btn-default pull-right submitShopimind'
            ]
        ];

        $SPM_apiIdentification = Configuration::get('SPM_apiIdentification');
        if (!$SPM_apiIdentification) {
            $fieldsForm['config']['form']['buttons'] = array(
                array(
                    'href' => '',
                    'class' => 'spm_back_config_page',
                    'title' => $this->l('Back'),
                    'icon' => 'process-icon-back'
                )
            );
        }

        $helper = new HelperForm();
        $helper->fields_value['apiIdentification'] = htmlentities(
            Configuration::get('SPM_apiIdentification'),
            ENT_COMPAT,
            'UTF-8'
        );
        $helper->fields_value['apiPassword'] = htmlentities(
            Configuration::get('SPM_apiPassword'),
            ENT_COMPAT,
            'UTF-8'
        );
        $helper->fields_value['realtimeSync'] = Configuration::get('SPM_realtimeSync');
        $helper->fields_value['cacheWorkaround'] = Configuration::get('SPM_cacheWorkaround');

        $helper->fields_value['voucherNominative'] = Configuration::get('SPM_voucherNominative');
        $helper->fields_value['voucherHighlight'] = Configuration::get('SPM_voucherHighlight');
        $helper->fields_value['voucherCumulablePromo'] = Configuration::get('SPM_voucherCumulablePromo');
        $helper->fields_value['voucherCumulableVoucher'] = Configuration::get('SPM_voucherCumulableVoucher');
        $helper->fields_value['excludeOutOfStockProducts'] = Configuration::get('SPM_excludeOutOfStockProducts');
        $helper->fields_value['productImageSize'] = Configuration::get('SPM_productImageSize');
        $helper->fields_value['syncNL'] = Configuration::get('SPM_syncNL');
        $helper->fields_value['syncNL_table'] = Configuration::get('SPM_syncNL_table');

        // Module, token and currentIndex
        $helper->module = $this;
        $helper->name_controller = $this->name;
        $helper->token = Tools::getAdminTokenLite('AdminModules');
        $helper->currentIndex = AdminController::$currentIndex.'&configure='.$this->name;

        // Language
        $helper->default_form_language = $defaultLang;
        $helper->allow_employee_form_lang = $defaultLang;

        // Title and toolbar
        $helper->title = $this->displayName;
        $helper->show_toolbar = true;
        $helper->toolbar_scroll = true;
        $helper->submit_action = 'submitShopimind';

        $output = $helper->generateForm($fieldsForm);

        if ($hide) {
            $output = str_replace(
                'id="configuration_form"',
                'id="configuration_form" style="display:none"',
                $output
            );
        }

        $url = Tools::getHttpHost(true).__PS_BASE_URI__;
        if (Tools::substr($url, -1) != '/') {
            $url .= '/';
        }

        $url .= str_replace(
            dirname(_PS_MODULE_DIR_).'/',
            '',
            _PS_MODULE_DIR_
        ).$this->name.'/ShopimindClient/asyncCall.php';

        $fields = explode('|', Configuration::get('SPM_syncNL_table_fields'));

        $this->context->smarty->assign(array(
            'fields' => implode(",", $fields),
            'url' => $url,
        ));

        $assets = $this->display(__FILE__, 'views/templates/admin/config_page.tpl');

        return $output.$assets;
    }

    protected function getRegisterForm($hide = false, $messages = false)
    {
        /* Si la version de prestashop est inférieur à 1.5 => utiliser le formulaire sans helperForm class */
        if (_PS_VERSION_ < '1.6') {
            return $this->getRegisterFormLower($hide);
        }

        $defaultLang = (int)Configuration::get('PS_LANG_DEFAULT');

        $countries = Country::getCountries(Configuration::get('PS_LANG_DEFAULT'), false);
        $countriesOptions = array();
        foreach ($countries as $country) {
            $countriesOptions[] = array(
                'id_option' => $country['iso_code'],
                'name' => $country['name'],
            );
        }
        $fieldsForm = array('register' => array('form' => array()));

        $fieldsForm['register']['form'] = [
            'legend' => [
                'title' => $this->l('Create my ShopiMind account'),
                'image' => $this->_path . 'logo.gif',
            ],
            'input' => [
                [
                    'type' => 'text',
                    'label' => $this->l('Email address'),
                    'name' => 'spm_register_email',
                    'size' => 20,
                    'required' => true
                ],
                [
                    'type' => 'password',
                    'label' => $this->l('Password'),
                    'name' => 'spm_register_password',
                    'size' => 20,
                    'required' => true
                ],
                [
                    'type' => 'password',
                    'label' => $this->l('Confirm password'),
                    'name' => 'spm_register_passwordConfirm',
                    'size' => 20,
                    'required' => true
                ],
                [
                    'type' => 'text',
                    'label' => $this->l('Shop URL'),
                    'name' => 'spm_register_url',
                    'size' => 20,
                    'required' => true
                ],
                [
                    'type' => 'text',
                    'label' => $this->l('First name'),
                    'name' => 'spm_register_firstName',
                    'size' => 20,
                    'required' => true
                ],
                [
                    'type' => 'text',
                    'label' => $this->l('Last Name'),
                    'name' => 'spm_register_lastName',
                    'size' => 20,
                    'required' => true
                ],
                [
                    'type' => 'text',
                    'label' => $this->l('Company'),
                    'name' => 'spm_register_societe',
                    'size' => 20,
                    'required' => true
                ],
                [
                    'type' => 'text',
                    'label' => $this->l('VAT number'),
                    'name' => 'spm_register_vat_number',
                    'size' => 20,
                    'required' => false
                ],
                [
                    'type' => 'text',
                    'label' => $this->l('Landline number'),
                    'name' => 'spm_register_phoneFixe',
                    'size' => 20,
                    'required' => true
                ],
                [
                    'type' => 'text',
                    'label' => $this->l('Mobile phone number'),
                    'name' => 'spm_register_phoneMobile',
                    'size' => 20,
                    'required' => true
                ],
                [
                    'type' => 'text',
                    'label' => $this->l('Address'),
                    'name' => 'spm_register_rue',
                    'size' => 20,
                    'required' => true
                ],
                [
                    'type' => 'text',
                    'label' => $this->l('Address 2'),
                    'name' => 'spm_register_complement',
                    'size' => 20,
                    'required' => false
                ],
                [
                    'type' => 'text',
                    'label' => $this->l('PO Box'),
                    'name' => 'spm_register_bp',
                    'size' => 20,
                    'required' => false
                ],
                [
                    'type' => 'text',
                    'label' => $this->l('Zip code'),
                    'name' => 'spm_register_zipCode',
                    'size' => 20,
                    'required' => true
                ],
                [
                    'type' => 'text',
                    'label' => $this->l('City'),
                    'name' => 'spm_register_city',
                    'size' => 20,
                    'required' => true
                ],
                [
                    'type' => 'select',
                    'label' => $this->l('Country'),
                    'name' => 'spm_register_country',
                    'required' => true,
                    'options' => array(
                        'query' => $countriesOptions,
                        'id' => 'id_option',
                        'name' => 'name'
                    )
                ],
                [
                    'type' => 'text',
                    'label' => $this->l('Code promo'),
                    'name' => 'spm_promo_code',
                    'size' => 20,
                    'required' => false
                ],
            ],
            'submit' => [
                'title' => $this->l('Submit'),
                'class' => 'btn btn-default pull-right'
            ],
        ];

        $SPM_apiIdentification = Configuration::get('SPM_apiIdentification');
        if (!$SPM_apiIdentification) {
            $fieldsForm['register']['form']['buttons'] = array(
                array(
                    'href' => '',
                    'class' => 'spm_back_config_page',
                    'title' => $this->l('Back'),
                    'icon' => 'process-icon-back'
                )
            );
        }

        
        if ($messages) {
            foreach ($messages['shop']['user'] as $field_error => $message_error) {
                $input_name = "spm_register_".$field_error;
                foreach ($fieldsForm['register']['form']['input'] as $k1 => $value) {
                    if ($value['name'] == $input_name) {
                        if (is_string($message_error) && $message_error != "") {
                            $message_error = [$message_error];
                        }
                        if (is_array($message_error) && count($message_error) > 0) {
                            $this->context->smarty->assign(array(
                                'message_error' => $message_error,
                            ));
                            $fieldsForm['register']['form']['input'][$k1]['desc'] = $this->display(
                                __FILE__,
                                'views/templates/admin/errors/errors_span.tpl'
                            );
                        }
                    }
                }
            }
        }

        $helper = new HelperForm();
        $helper->fields_value['spm_register_email'] = Tools::getValue('spm_register_email') ?
            Tools::getValue('spm_register_email') : htmlentities(
                Configuration::get('PS_SHOP_EMAIL'),
                ENT_COMPAT,
                'UTF-8'
            );

        $helper->fields_value['spm_register_url'] = Tools::getValue('spm_register_url') ?
            Tools::getValue('spm_register_url') : Tools::getHttpHost(true).__PS_BASE_URI__;

        $helper->fields_value['spm_register_lastName'] = Tools::getValue('spm_register_lastName') ?
            Tools::getValue('spm_register_lastName') : '';
        $helper->fields_value['spm_register_firstName'] = Tools::getValue('spm_register_firstName') ?
            Tools::getValue('spm_register_firstName') : '';

        $helper->fields_value['spm_register_password'] = '';
        $helper->fields_value['spm_register_passwordConfirm'] = '';

        $helper->fields_value['spm_register_societe'] = Tools::getValue('spm_register_societe') ?
            Tools::getValue('spm_register_societe') : htmlentities(
                Configuration::get('PS_SHOP_NAME'),
                ENT_COMPAT,
                'UTF-8'
            );

        $helper->fields_value['spm_register_vat_number'] = Tools::getValue('spm_register_vat_number') ?
            Tools::getValue('spm_register_vat_number') : '';

        $helper->fields_value['spm_register_phoneFixe'] = Tools::getValue('spm_register_phoneFixe') ?
            Tools::getValue('spm_register_phoneFixe') : htmlentities(
                Configuration::get('PS_SHOP_PHONE'),
                ENT_COMPAT,
                'UTF-8'
            );
        $helper->fields_value['spm_register_phoneMobile'] = Tools::getValue('spm_register_phoneMobile') ?
            Tools::getValue('spm_register_phoneMobile') : htmlentities(
                Configuration::get('PS_SHOP_PHONE'),
                ENT_COMPAT,
                'UTF-8'
            );

        $helper->fields_value['spm_register_rue'] =  Tools::getValue('spm_register_rue') ?
            Tools::getValue('spm_register_rue') : htmlentities(
                Configuration::get('PS_SHOP_ADDR1'),
                ENT_COMPAT,
                'UTF-8'
            );
        $helper->fields_value['spm_register_complement'] =  Tools::getValue('spm_register_complement') ?
            Tools::getValue('spm_register_complement') : htmlentities(
                Configuration::get('PS_SHOP_ADDR2'),
                ENT_COMPAT,
                'UTF-8'
            );
        $helper->fields_value['spm_register_bp'] = Tools::getValue('spm_register_bp') ?
            Tools::getValue('spm_register_bp') : '';

        $helper->fields_value['spm_register_zipCode'] = Tools::getValue('spm_register_zipCode') ?
            Tools::getValue('spm_register_zipCode') :  htmlentities(
                Configuration::get('PS_SHOP_CODE'),
                ENT_COMPAT,
                'UTF-8'
            );

        $helper->fields_value['spm_register_city'] = Tools::getValue('spm_register_city') ?
            Tools::getValue('spm_register_city') : htmlentities(
                Configuration::get('PS_SHOP_CITY'),
                ENT_COMPAT,
                'UTF-8'
            );

        $helper->fields_value['spm_register_country'] = Tools::getValue('spm_register_country') ?
            Tools::getValue('spm_register_country') : htmlentities(
                Country::getIsoById(Configuration::get('PS_SHOP_COUNTRY_ID')),
                ENT_COMPAT,
                'UTF-8'
            );


        // Module, token and currentIndex
        $helper->module = $this;
        $helper->name_controller = $this->name;
        $helper->token = Tools::getAdminTokenLite('AdminModules');
        $helper->currentIndex = AdminController::$currentIndex.'&configure='.$this->name;

        // Language
        $helper->default_form_language = $defaultLang;
        $helper->allow_employee_form_lang = $defaultLang;

        // Title and toolbar
        $helper->title = $this->displayName;
        $helper->show_toolbar = true;
        $helper->toolbar_scroll = true;
        $helper->submit_action = 'submitRegisterShopimind';

        $output = $helper->generateForm($fieldsForm);

        $output = str_replace(
            'id="configuration_form"',
            'id="configuration_form_1"',
            $output
        );

        if ($hide) {
            $output = str_replace(
                'id="configuration_form_1"',
                'id="configuration_form_1" style="display:none"',
                $output
            );
        }

        $css = $this->display(__FILE__, 'views/templates/admin/css/register_page.tpl');

        return $output.$css;
    }

    /*
     * Anciennes methodes de génération de formulaire de configuration/inscription
     * destinées aux version prestashop inférieur a 1.5
     */


    protected function getConfigFormLower($hide = false)
    {
        /**
         * Permet de synchroniser les abonnés newsletter de la boutique vers une liste dans Shopimind
         */
        $results = Db::getInstance(_PS_USE_SQL_SLAVE_)->executeS('SHOW TABLES LIKE "' . _DB_PREFIX_ . '%"');
        $tables_nl = array();
        if ($results && is_array($results) && sizeof($results)) {
            foreach ($results as $row) {
                $keys = array_keys($row);
                $tables_nl[] = $row[$keys[0]];
            }
        }

        $url = Tools::getHttpHost(true) . __PS_BASE_URI__;
        if (Tools::substr($url, -1) != '/') {
            $url .= '/';
        }
        $url .= str_replace(
            dirname(_PS_MODULE_DIR_).'/',
            '',
            _PS_MODULE_DIR_
        ).$this->name.'/ShopimindClient/asyncCall.php';

        $fields = explode('|', Configuration::get('SPM_syncNL_table_fields'));

        $this->context->smarty->assign(array(
            'visibility' => $hide ? 'hide' : 'show',
            'logo' => $this->_path .'logo.gif',
            'SPM_apiIdentification' => Configuration::get('SPM_apiIdentification') ?
                htmlentities(Configuration::get('SPM_apiIdentification'), ENT_COMPAT, 'UTF-8') : "",
            'SPM_apiPassword' => htmlentities(
                Configuration::get('SPM_apiPassword'),
                ENT_COMPAT,
                'UTF-8'
            ),
            'SPM_realtimeSync' => Tools::getValue('realtimeSync', Configuration::get('SPM_realtimeSync')),
            'SPM_cacheWorkaround' => Tools::getValue('cacheWorkaround', Configuration::get('SPM_cacheWorkaround')),
            'SPM_voucherNominative' => Tools::getValue(
                'voucherNominative',
                Configuration::get('SPM_voucherNominative')
            ),
            'SPM_voucherHighlight' => Tools::getValue('voucherHighlight', Configuration::get('SPM_voucherHighlight')),
            'SPM_voucherCumulablePromo' => Tools::getValue(
                'voucherCumulablePromo',
                Configuration::get('SPM_voucherCumulablePromo')
            ),
            'SPM_voucherCumulableVoucher' => Tools::getValue(
                'voucherCumulableVoucher',
                Configuration::get('SPM_voucherCumulableVoucher')
            ),
            'SPM_excludeOutOfStockProducts' => Tools::getValue(
                'excludeOutOfStockProducts',
                Configuration::get('SPM_excludeOutOfStockProducts')
            ),
            'SPM_syncNL' => Tools::getValue('syncNL', Configuration::get('SPM_syncNL')),
            'productImageSizes' => $this->getProductImageSizes(),
            'currentProductImageSize' => Configuration::get('SPM_productImageSize'),
            'tables_nl' => $tables_nl,
            'SPM_syncNL_table' => Tools::getValue('syncNL_table', Configuration::get('SPM_syncNL_table')),
            'url' => $url,
            'fields' => implode(",", $fields)
        ));

        return $this->display(__FILE__, 'views/templates/admin/old/config_page.tpl');
    }

    protected function getRegisterFormLower($hide = false)
    {
        try {
            $SHOPIMIND_CLIENT_CONFIGURATION = require _PS_MODULE_DIR_.$this->name.
                '/ShopimindClient/src/definitions.php';
        } catch (Exception $e) {
        }


        $this->context->smarty->assign(array(
            'visibility' => $hide ? 'hide' : 'show',
            'SPM_apiIdentification' => Configuration::get('SPM_apiIdentification') ?
                Configuration::get('SPM_apiIdentification') : "",
            'promo_code' => htmlentities(
                @$SHOPIMIND_CLIENT_CONFIGURATION['promo_code'],
                ENT_COMPAT,
                'UTF-8'
            ),
            'url_register' => @$SHOPIMIND_CLIENT_CONFIGURATION["api"]["register_action_url"],
            'logo' => $this->_path .'logo.gif',
            'ps_shop_email' => htmlentities(
                Configuration::get('PS_SHOP_EMAIL'),
                ENT_COMPAT,
                'UTF-8'
            ),
            'shop_url' => Tools::getHttpHost(true) . __PS_BASE_URI__,
            'ps_shop_name' => htmlentities(
                Configuration::get('PS_SHOP_NAME'),
                ENT_COMPAT,
                'UTF-8'
            ),
            'ps_phone' => htmlentities(
                Configuration::get('PS_SHOP_PHONE'),
                ENT_COMPAT,
                'UTF-8'
            ),
            'ps_shop_addr1' => htmlentities(
                Configuration::get('PS_SHOP_ADDR1'),
                ENT_COMPAT,
                'UTF-8'
            ),
            'ps_shop_addr2' => htmlentities(
                Configuration::get('PS_SHOP_ADDR2'),
                ENT_COMPAT,
                'UTF-8'
            ),
            'ps_zip_code' => htmlentities(
                Configuration::get('PS_SHOP_CODE'),
                ENT_COMPAT,
                'UTF-8'
            ),
            'ps_city' => htmlentities(
                Configuration::get('PS_SHOP_CITY'),
                ENT_COMPAT,
                'UTF-8'
            ),
            'countries' =>  Country::getCountries(Configuration::get('PS_LANG_DEFAULT'), false),
            'ps_shop_country_id' => Country::getIsoById(Configuration::get('PS_SHOP_COUNTRY_ID')),
        ));

        return $this->display(__FILE__, 'views/templates/admin/old/register_page.tpl');
    }
}
