{*
 * Shopimind
 *
 * @author    Shopimind
 * @copyright Copyright (c) Shopimind 2021
 * @license   Commercial license
 *}

<script type='text/javascript'>
    {literal}
    var currentFields;
    $(document).ready(function(){
        currentFields = '{/literal}{$fields|escape:'javascript':'UTF-8'}{literal}';
        currentFields = currentFields.split(',');
        $('<div class="form-group" id="syncNL_config"><label class="control-label col-lg-3">' +
            '{/literal}{l s='Field assignment' mod='shopimind'}{literal}</label><div id="syncNL_fields"></div></div>')
            .insertAfter($('select[name=syncNL_table]').parents('.form-group'));

        toggleVoucherHighlight();
        toggleSyncNL();
        toggleSyncNLFields();

        $('input[name=voucherNominative]').on('change',function(){
            toggleVoucherHighlight();
        });

        $('input[name=syncNL]').on('change',function(){
            toggleSyncNL();
        });

        $('select[name=syncNL_table]').on('change',function(){
            toggleSyncNLFields();
        });

    });

    function toggleVoucherHighlight(){
        if($('input[name=voucherHighlight]').parents('.form-group').length){
            if($('input[name=voucherNominative]:checked').val() == 1){
                $('input[name=voucherHighlight]').parents('.form-group').show();
            }else{
                $('input[name=voucherHighlight]').parents('.form-group').hide();
                $('input#voucherHighlight_off').attr('checked','checked');
            }
        }
    }

    function toggleSyncNL(){
        if($('#syncNL_config').length){
            if($('input[name=syncNL]:checked').val() == 1){
                $('select[name=syncNL_table]').parents('.form-group').show();
            }else{
                $('#syncNL_config').hide();
                $('input#syncNL_off').attr('checked','checked');
                $('select[name=syncNL_table]').parents('.form-group').hide();
                $('select[name=syncNL_table]').val('').trigger('change');
            }
            $('select[name=syncNL_table]').trigger('change');
        }
    }

    function toggleSyncNLFields(){
        if($('#syncNL_fields').length){
            if($('select[name=syncNL_table]').val() != ''){
                $('#syncNL_config').show();
                $('#syncNL_fields').html("{/literal}{l s='Recovering fields from the table ...' mod='shopimind'}{literal}");

                $.ajax({
                    type: 'GET',
                    dataType: 'json',
                    url: "{/literal}{$url|escape:'javascript':'UTF-8'}{literal}",
                    data: {action: 'getTableFields', table : $('select[name=syncNL_table]').val()},
                    success: function(response){
                        $('#syncNL_fields').html('');
                        if(response.success && response.fields.length > 0) {
                            for(var i in response.fields) {
                                var emailRegex = /email/;
                                var div = $('<div class="spm_nl_div_1"></div>').html(
                                    '<div class="spm_nl_div_2">' + response.fields[i] + '</div>' +
                                    '<div style="margin-top: 3px; text-align: center;"> ' +
                                    '<select name="syncNL_fields[]" style="width: 100%;"> ' +
                                    '<option value="" ' + (currentFields.indexOf(response.fields[i]) == -1 ? 'selected="selected"' : '') + '>{/literal}{l s='Exclude' mod='shopimind'}{literal}</option>' +
                                    '<option value="' + response.fields[i] + '-id_shop"  ' + (currentFields.indexOf(response.fields[i] + '-id_shop') >= 0 ? 'selected="selected"' : '') + '>{/literal}{l s='ID Shop' mod='shopimind'}{literal}</option>' +
                                    '<option value="' + response.fields[i] + '-last_name" ' +  (currentFields.indexOf(response.fields[i] + '-last_name') >= 0 ? 'selected="selected"' : '') + '>{/literal}{l s='Last Name' mod='shopimind'}{literal}</option>' +
                                    '<option value="' + response.fields[i] + '-first_name" ' + (currentFields.indexOf(response.fields[i] + '-first_name') >= 0 ? 'selected="selected"' : '') + '>{/literal}{l s='First Name' mod='shopimind'}{literal}</option>' +
                                    '<option value="' + response.fields[i] + '-email" ' + (currentFields.indexOf(response.fields[i] + '-email') >= 0 || emailRegex.test(response.fields[i]) ? 'selected="selected"' : '') + '>{/literal}{l s='Email' mod='shopimind'}{literal}</option>' +
                                    '<option value="' + response.fields[i] + '-zipcode" ' + (currentFields.indexOf(response.fields[i] + '-zipcode') >= 0 ? 'selected="selected"' : '') + '>{/literal}{l s='Zip code' mod='shopimind'}{literal}</option>' +
                                    '<option value="' + response.fields[i] + '-last_update" ' + (currentFields.indexOf(response.fields[i] + '-last_update') >= 0 ? 'selected="selected"' : '') + '>{/literal}{l s='Date' mod='shopimind'}{literal}</option>' +
                                    '<option value="' + response.fields[i] + '-status" ' + (currentFields.indexOf(response.fields[i] + '-status') >= 0 ? 'selected="selected"' : '') + '>{/literal}{l s='Status' mod='shopimind'}{literal}</option>' +
                                    '<option value="' + response.fields[i] + '-lang" ' + (currentFields.indexOf(response.fields[i] + '-lang') >= 0 ? 'selected="selected"' : '') + '>{/literal}{l s='Lang' mod='shopimind'}{literal}</option>' +
                                    '</select>' +
                                    '</div>'
                                );
                                $('#syncNL_fields').append(div);
                            }
                        }
                    }
                });
            }else{
                $('#syncNL_config').hide();
            }
        }
    }
    {/literal}
</script>

<style>
    .shopimind .panel-heading img {
        height: 16px;
        width: 16px;
    }
    .spm_nl_div_1 {
        float: left;
        padding: 5px 10px;
        background: #FFFFFF;
        border-radius: 3px;
        border: solid 1px lightgrey;
        top: 0;
        vertical-align: top;
        margin-right: 5px;
        margin-bottom: 5px;
    }
    .spm_nl_div_2 {
        margin-bottom: 5px;
        font-size: 12px;
        text-align: center;
        display: block;
    }
</style>
