<?php
/**
* 2010-2021 Webkul.
*
* NOTICE OF LICENSE
*
* All right is reserved,
* Please go through LICENSE.txt file inside our module
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade this module to newer
* versions in the future. If you wish to customize this module for your
* needs please refer to CustomizationPolicy.txt file inside our module for more information.
*
* @author Webkul IN
* @copyright 2010-2021 Webkul IN
* @license LICENSE.txt
*/

class AdminWkBlogPostConfigurationController extends ModuleAdminController
{
    public function __construct()
    {
        $this->table = 'configuration';
        $this->className = '';
        $this->bootstrap = true;
        $this->absolutePath = _PS_MODULE_DIR_.'wkblogpost/views/img/default/';
        parent::__construct();
    }

    public function initContent()
    {
        // $this->initToolbar();
        $this->display = '';
        $this->content .= $this->renderForm();

        $this->context->smarty->assign(
            array(
                'content' => $this->content
            )
        );
        parent::initContent();
    }

    public function renderForm()
    {
        $default_img = $this->absolutePath.'/custom-default.jpg';
        if (file_exists($default_img)) {
            $this->context->smarty->assign(
                array(
                    'default_img' => _MODULE_DIR_.'wkblogpost/views/img/default/custom-default.jpg',
                    'default' => 1,
                    'show_delete_for_default_img' => 1
                )
            );
        } else {
            $this->context->smarty->assign(
                array(
                    'default_img' => _MODULE_DIR_.'wkblogpost/views/img/default/home-default.png',
                    'default' => 1
                )
            );
        }
        $defaultProfileImg = $this->absolutePath.'/custom-autor-profile.jpg';
        if (file_exists($defaultProfileImg)) {
            $this->context->smarty->assign(
                array(
                    'default_profile_img' => _MODULE_DIR_.'wkblogpost/views/img/default/custom-autor-profile.jpg',
                    'default_profile' => 1,
                    'show_delete_for_author_img' => 1
                )
            );
        } else {
            $this->context->smarty->assign(
                array(
                    'default_profile_img' => _MODULE_DIR_.'wkblogpost/views/img/default/autor-profile.jpg',
                    'default_profile' => 1
                )
            );
        }
        $this->context->smarty->assign(
            array(
                'show_thumbnail' => Configuration::get('WK_SHOW_AUTHOR_THUMBNAIL'),
                'wk_blog_author' => Configuration::get('WK_BLOG_POST_AUTHOR_NAME'),
                'no_post' => Configuration::get('WK_NO_OF_BLOG_POST'),
                'category_on' => Configuration::get('WK_BLOG_CATEGORY_ON'),
                'no_cat' => Configuration::get('WK_NO_OF_BLOG_CATEGORY'),
            )
        );
        $this->fields_form = array(
            'submit' => array(
                'title' => $this->l('Save'),
                ),
            );

        return parent::renderForm();
    }

    public function processSave()
    {
        $obj_wkimg = new WkBlogPostImage();
        if (Tools::isSubmit('SubmitBlogConfiguration')) {
            $category_on = (int) Tools::getValue('category_on');
            $wk_blog_author = trim(Tools::getValue('wk_blog_author'));
            $no_cat = Tools::getValue('wk_no_cat');
            $no_post = Tools::getValue('wk_no_post');
            $show_thumbnail = Tools::getValue('show_thumbnail');
            $default_blogimg = Tools::getValue('default_blogimg');
            $default_img = $_FILES['wktheme_default']['name'];
            $default_profile_img = $_FILES['wkthumbnail_image']['name'];
            $defaultProfileImg = Tools::getValue('default_profile_img');
            if ($category_on) {
                if (!Tools::strlen($no_cat)) {
                    $this->errors[] = $this->l('No. of category field is a required field.');
                } elseif (!Validate::isInt($no_cat)) {
                    $this->errors[] = $this->l('No. of category must be a numeric value.');
                } elseif ($no_cat <= 0) {
                    $this->errors[] = $this->l('No. of category must be greater than zero.');
                }
            }
            if (!Tools::strlen($no_post)) {
                $this->errors[] = $this->l('No. of post field is a required field.');
            } elseif (!Validate::isInt($no_post)) {
                $this->errors[] = $this->l('No. of post must be a numeric value.');
            } elseif ($no_post <= 0) {
                $this->errors[] = $this->l('No. of post must be greater than zero.');
            }
            if (!$wk_blog_author) {
                $this->errors[] = $this->l('Please set author name.');
            } elseif (!Validate::isCatalogName($wk_blog_author)) {
                $this->errors[] = $this->l('Author name is not valid.');
            }
            if (!empty($default_img)) {
                if (!$obj_wkimg->validateImageExt($_FILES['wktheme_default'])) {
                    $this->errors[] = $this->l('Invalid blog image, allowed formats are: .gif, .jpg, .png');
                } elseif (!empty($default_img)) {
                    $obj_wkimg->uploadFeatureImage(0, 'default');
                }
            } else {
                if (!$default_blogimg) {
                    $this->errors[] = $this->l('Image required for block view theme.');
                }
            }
            if ($show_thumbnail) {
                if (!empty($default_profile_img)) {
                    if (!$obj_wkimg->validateImageExt($_FILES['wkthumbnail_image'])) {
                        $this->errors[] = $this->l('Invalid author image, allowed formats are: .gif, .jpg, .png');
                    } elseif (!empty($default_profile_img)) {
                        $obj_wkimg->uploadFeatureImage(0, 'default_profile');
                    }
                } else {
                    if (!$defaultProfileImg) {
                        $this->errors[] = $this->l('Profile image is required.');
                    }
                }
            }
            if (empty($this->errors)) {
                Configuration::updateValue('WK_BLOG_CATEGORY_ON', $category_on);
                Configuration::updateValue('WK_NO_OF_BLOG_POST', $no_post);
                Configuration::updateValue('WK_NO_OF_BLOG_CATEGORY', $no_cat);
                Configuration::updateValue('WK_BLOG_POST_AUTHOR_NAME', $wk_blog_author);
                Configuration::updateValue('WK_SHOW_AUTHOR_THUMBNAIL', $show_thumbnail);
                Tools::redirectAdmin(self::$currentIndex.'&conf=4&token='.$this->token);
            }
        }
    }

    public function setMedia($isNewTheme = false)
    {
        parent::setMedia($isNewTheme);

        Media::addJsDef(
            array(
                'filesizeError' => $this->l('File exceeds maximum size.'),
                'maxSizeAllowed' => Configuration::get('PS_ATTACHMENT_MAXIMUM_SIZE'),
            )
        );
        $this->addCSS(_MODULE_DIR_.'wkblogpost/views/css/configuration.css');
        $this->addJS(_MODULE_DIR_.'wkblogpost/views/js/admin/configuration.js');
    }

    public function postProcess()
    {
        if (!$this->loadObject(true)) {
            return;
        }

        // delete default image for the blog
        if (Tools::getValue('id_delete')) {
            $path = $this->absolutePath.'/custom-default.jpg';
            if (file_exists($path)) {
                unlink($path);
            }
            Tools::redirectAdmin(
                self::$currentIndex.'&token='.
                Tools::getAdminTokenLite('AdminWkBlogPostConfiguration').
                '&conf=1'
            );
        }
        if (Tools::getValue('id_profile_delete')) {
            $path = $this->absolutePath.'/custom-autor-profile.jpg';
            if (file_exists($path)) {
                unlink($path);
            }
            Tools::redirectAdmin(
                self::$currentIndex.'&token='.
                Tools::getAdminTokenLite('AdminWkBlogPostConfiguration').
                '&conf=1'
            );
        }
        parent::postProcess();
    }
}
