/**
* 2010-2021 Webkul.
*
* NOTICE OF LICENSE
*
* All right is reserved,
* Please go through LICENSE.txt file inside our module
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade this module to newer
* versions in the future. If you wish to customize this module for your
* needs please refer to CustomizationPolicy.txt file inside our module for more information.
*
* @author Webkul IN
* @copyright 2010-2021 Webkul IN
* @license LICENSE.txt
*/

$(document).ready(function(){

    // Uploading thumbnail image
	if ($('input[name="show_thumbnail"]:checked').val() == 1) {
		$('#wkthumbnail_img').show();
	} else {
		$('#wkthumbnail_img').hide();
	}

    $('.thumbnail_slide').on('change', function() {
    	if ($('input[name="show_thumbnail"]:checked').val() == 1) {
    		$('#wkthumbnail_img').show('slow');
    	} else {
    		$('#wkthumbnail_img').hide('slow');
    	}
    });

    // profile image upload using button
    $('#profile_file_selectbutton').click(function(e){
        $('#profile_file').trigger('click');
    });

    $('#profile_file_name').click(function(e){
        $('#profile_file').trigger('click');
    });

    $('#profile_file').change(function(e){
        var val = $(this).val();
        var file = val.split(/[\\/]/);
        $('#profile_file_name').val(file[file.length-1]);
    });

    // features images upload using button
    $('#file-selectbutton').click(function(e){
        $('#file').trigger('click');
    });

    $('#file-name').click(function(e){
        $('#file').trigger('click');
    });

    $('#file').change(function(e){
        var val = $(this).val();
        var file = val.split(/[\\/]/);
        $('#file-name').val(file[file.length-1]);
    });

    $('input[type="file"]').on('change', function() {
		if (typeof this.files[0] != 'undefined') {
			if (this.files[0].size > maxSizeAllowed*1000000) {
                $.growl.error({ title: "", message: filesizeError });
				setTimeout(function() {
                    location.reload();
                }, 1000);
			}
		}
	});

    // number of category
    $('.side_bar_category').on('change', function(){
    	if ($('.side_bar_category :checked').val() == 1) {
    		$('#no_category').show('slow');
    	} else {
    		$('#no_category').hide('slow');
    	}
    });

    if ($('.side_bar_category :checked').val() == 1) {
		$('#no_category').show('slow');
	} else {
		$('#no_category').hide('slow');
	}
});