{**
* 2010-2021 Webkul.
*
* NOTICE OF LICENSE
*
* All right is reserved,
* Please go through LICENSE.txt file inside our module
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade this module to newer
* versions in the future. If you wish to customize this module for your
* needs please refer to CustomizationPolicy.txt file inside our module for more information.
*
* @author Webkul IN
* @copyright 2010-2021 Webkul IN
* @license LICENSE.txt
*}

<div class="panel">
    <div class="panel-heading">
		<i class="icon-user"></i>
        {if isset($id_blog)}
            {l s='Update Post' mod='wkblogpost'}
        {else}
            {l s='New Post' mod='wkblogpost'}
        {/if}
	</div>
    <form
        id="{$table}_form"
        class="defaultForm {$name_controller} form-horizontal"
        action="{$current}&{if isset($id_blog)}update{$table}&id_wk_blog_post={$id_blog|intval}{else}add{$table}{/if}&token={$token}"
        method="post"
        enctype="multipart/form-data">
        <div class="form-group">
            <label class="control-label col-lg-3 required">
                <span title="" data-toggle="tooltip" class="label-tooltip" data-original-title="{l s='Choose category for this post' mod='wkblogpost'}">
                    {l s='Choose Category' mod='wkblogpost'}
                </span>
            </label>
            <div class="col-lg-3">
                <select id="wkblog_cat" name="wkblog_cat" class="fixed-width-xl">
                    {if !empty($all_cat)}
                        {foreach $all_cat as $cat}
                            <option value="{$cat.id_wk_blogpost_category|intval}" id="{$cat.id_wk_blogpost_category|intval}" {if isset($smarty.post.wkblog_cat) && $smarty.post.wkblog_cat == $cat.id_wk_blogpost_category}selected="selected"{else if isset($obj_wkpost) && $obj_wkpost->id_category|intval == $cat.id_wk_blogpost_category|intval}selected="selected"{/if}>{$cat.title}</option>
                        {/foreach}
                    {/if}
                </select>
            </div>
        </div>
        <div class="form-group">
            <label class="control-label col-lg-3 required">
    			<span title="" data-toggle="tooltip" class="label-tooltip" data-original-title="{l s='Invalid characters <>;=#\{\}' mod='wkblogpost'}">
    				{l s='Title' mod='wkblogpost'}
    			</span>
    		</label>
    		<div class="col-lg-7">
    			{foreach from=$languages item=language}
                    {assign var="wkblog_title" value="wkblog_title_`$language.id_lang`"}
                    <input type="text" id="name_{$language.id_lang}" name="wkblog_title_{$language.id_lang}" value="{if isset($obj_wkpost)}{$obj_wkpost->title.{$language.id_lang}}{else if isset($smarty.post.$wkblog_title)}{$smarty.post.$wkblog_title}{/if}" class="form-control copyMeta2friendlyURL all_wkfield" onkeyup="if (isArrowKey(event)) return ;updateFriendlyURL();"
                    {if $id_lang != $language.id_lang}style="display:none;"{/if} />
                {/foreach}
            </div>
            {if $total_languages > 1}
            <div class="col-lg-2">
                <button type="button" id="title_lang_btn" class="btn btn-default dropdown-toggle wklang" data-toggle="dropdown">
                    {$iso}
                    <span class="caret"></span>
                </button>
                <ul class="dropdown-menu">
                    {foreach from=$languages item=language}
                        <li>
                            <a href="javascript:hideOtherLanguage({$language.id_lang});" onclick="showProdLangField('{$language.iso_code}', {$language.id_lang});">{$language.name}</a>
                        </li>
                    {/foreach}
                </ul>
            </div>
            {/if}
    	</div>
        <div class="form-group">
    		<label class="control-label col-lg-3 required">
    			<span title="" data-toggle="tooltip" class="label-tooltip" data-original-title="{l s='Only letters and the hyphen (-) character are allowed.' mod='wkblogpost'}">
    				{l s='Friendly URL' mod='wkblogpost'}
    			</span>
    		</label>
    		<div class="col-lg-7">
                {foreach from=$languages item=language}
                    {assign var="link_rewrite" value="link_rewrite_`$language.id_lang`"}
                    <input type="text" id="link_rewrite_{$language.id_lang}" name="link_rewrite_{$language.id_lang}" value="{if isset($obj_wkpost)}{$obj_wkpost->link_rewrite.{$language.id_lang}}{else if isset($smarty.post.$link_rewrite)}{$smarty.post.$link_rewrite}{/if}" class="form-control all_wkfield" onkeyup="if (isArrowKey(event)) return ;updateFriendlyURL();"
                    {if $id_lang != $language.id_lang}style="display:none;"{/if} />
                {/foreach}
            </div>
            {if $total_languages > 1}
            <div class="col-lg-2">
                <button type="button" id="link_lang_btn" class="btn btn-default dropdown-toggle wklang" data-toggle="dropdown">
                    {$iso}
                    <span class="caret"></span>
                </button>
                <ul class="dropdown-menu">
                    {foreach from=$languages item=language}
                        <li>
                            <a href="javascript:hideOtherLanguage({$language.id_lang});" onclick="showProdLangField('{$language.iso_code}', {$language.id_lang});">{$language.name}</a>
                        </li>
                    {/foreach}
                </ul>
            </div>
            {/if}
    	</div>
        <div class="form-group">
            <label for="file" class="control-label col-lg-3">
                <span class="label-tooltip" data-toggle="tooltip" title="{l s='Upload an image from your computer.' mod='wkblogpost'}">{l s='Featured Image' mod='wkblogpost'}</span>
            </label>
            <div class="col-sm-9">
                <div class="row">
                    <div class="col-lg-7">
                        <input id="file" type="file" name="wkpost_featured" class="hide" />
                        <div class="dummyfile input-group">
                            <span class="input-group-addon"><i class="icon-file"></i></span>
                            <input id="file-name" type="text" class="disabled" name="filename" readonly />
                            <span class="input-group-btn">
                                <button id="file-selectbutton" type="button" name="submitAddAttachments" class="btn btn-default">
                                    <i class="icon-folder-open"></i> {l s='Choose a file' mod='wkblogpost'}
                                </button>
                            </span>
                        </div>
                    </div>
                </div>
                <div class="help-block">{l s='For best fit image size should be 830x400 ' mod='wkblogpost'}</div>
            </div>
        </div>
        {if isset($id_blog) && isset($featuredImage)}
            <div class="form-group">
                <label class="control-label col-lg-3">

                </label>
                <div class="col-lg-7">
                    <img
                        class="wkfeature_img"
                        src="{$module_dir}/wkblogpost/views/img/blog/{$id_blog|intval}/{$id_blog|intval}_blog.jpg?time={$time}"
                        title="{l s='Feature Image' mod='wkblogpost'}">
                    <p style="float:left; margin-left:90px;">
                        <a href="{$link->getAdminLink('AdminWkBlogPost')}&amp;wk_blog=1&amp;id_delete={$id_blog|intval}" class="btn btn-default">
                        <i class="icon-trash"></i>{l s='Delete' mod='wkblogpost'}
                    </a>
                </p>
                </div>
            </div>
        {/if}
        <div class="form-group">
            <label for="file" class="control-label col-lg-3">
                <span
                    class="label-tooltip"
                    data-toggle="tooltip"
                    title="{l s='Upload an image from your computer.' mod='wkblogpost'}">
                    {l s='Thumbnail Image' mod='wkblogpost'}
                </span>
            </label>
            <div class="col-sm-9">
                <div class="row">
                    <div class="col-lg-7">
                        <input id="thumbnail_file" type="file" name="wkpost_thumbnail" class="hide" />
                        <div class="dummyfile input-group">
                            <span class="input-group-addon"><i class="icon-file"></i></span>
                            <input id="thumbnail-file-name" type="text" class="disabled" name="filename" readonly />
                            <span class="input-group-btn">
                                <button
                                    type="button"
                                    id="thumbnail-file-selectbutton"
                                    name="submitThumbnail"
                                    class="btn btn-default">
                                    <i class="icon-folder-open"></i> {l s='Choose a file' mod='wkblogpost'}
                                </button>
                            </span>
                        </div>
                    </div>
                </div>
                <div class="help-block">
                    {l s='For best fit image size should be 168x168 ' mod='wkblogpost'}
                </div>
            </div>
        </div>
        {if isset($id_blog) && isset($thumbnailImage)}
            <div class="form-group">
                <label class="control-label col-lg-3">

                </label>
                <div class="col-lg-7">
                    <img
                        class="wkfeature_img"
                        src="{$module_dir}/wkblogpost/views/img/blog/{$id_blog|intval}/{$id_blog|intval}_blog_thumbnail.jpg?time={$time}"
                        title="{l s='Thumbnail Image' mod='wkblogpost'}">
                    <p style="float:left; margin-left:90px;">
                        <a href="{$link->getAdminLink('AdminWkBlogPost')}&amp;wk_blog_thumbnail=1&amp;id_delete={$id_blog|intval}" class="btn btn-default">
                        <i class="icon-trash"></i>{l s='Delete' mod='wkblogpost'}
                    </a>
                </p>
                </div>
            </div>
        {/if}
        <div class="form-group">
			<label class="control-label col-lg-3 required" for="product_description">
				<span title="" data-toggle="tooltip" class="label-tooltip" data-original-title="{l s='Main content of the post' mod='wkblogpost'}">
    				{l s='Description :' mod='wkblogpost'}
    			</span>
			</label>
			<div class="col-lg-8">
                {foreach from=$languages item=language}
                    {assign var="wkblog_desc" value="wkblog_desc_`$language.id_lang`"}
                    <div id="div_wkblog_desc_{$language.id_lang}" class="all_wkfield" {if $id_lang != $language.id_lang}style="display:none;"{/if}>
                        <textarea id="wkblog_desc_{$language.id_lang}" name="wkblog_desc_{$language.id_lang}" class="wkblog_tinymce form-control" >{if isset($obj_wkpost)}{$obj_wkpost->description.{$language.id_lang}}{/if}</textarea>
                    </div>
                {/foreach}
			</div>
            {if $total_languages > 1}
            <div class="col-lg-1">
                <button type="button" id="desc_lang_btn" class="btn btn-default dropdown-toggle wklang" data-toggle="dropdown">
                    {$iso}
                    <span class="caret"></span>
                </button>
                <ul class="dropdown-menu">
                    {foreach from=$languages item=language}
                        <li>
                            <a href="javascript:hideOtherLanguage({$language.id_lang});" onclick="showProdLangField('{$language.iso_code}', {$language.id_lang});">{$language.name}</a>
                        </li>
                    {/foreach}
                </ul>
            </div>
            {/if}
		</div>
        <div class="form-group">
            <label class="control-label col-lg-3">
                <span title="" data-toggle="tooltip" class="label-tooltip" data-original-title="{l s='Make this post visible' mod='wkblogpost'}">
                    {l s='Status' mod='wkblogpost'}
                </span>
            </label>
            <div class="col-lg-9 ">
                <span class="switch prestashop-switch fixed-width-lg">
                    <input type="radio" name="wkblog_status" id="wkblog_status_on" value="1" {if isset($smarty.post.wkblog_status) && $smarty.post.wkblog_status == 1}checked="checked"{else if isset($obj_wkpost) && $obj_wkpost->active == 1}checked="checked"{/if}>
                    <label for="wkblog_status_on">{l s='Yes' mod='wkblogpost'}</label>
                    {if isset($obj_wkpost)}
                    <input type="radio" name="wkblog_status" id="wkblog_status_off" value="0" {if $obj_wkpost->active == '0'}checked="checked"{else if isset($smarty.post.wkblog_status) && $smarty.post.wkblog_status == '0'}checked="checked"{/if}>
                    {else}
                    <input type="radio" name="wkblog_status" id="wkblog_status_off" value="0" {if isset($obj_wkpost->active) && $obj_wkpost->active == '0'}checked="checked"{else if isset($smarty.post.wkblog_status) && $smarty.post.wkblog_status == '0'}checked="checked"{else if !isset($smarty.post.wkblog_status)}checked="checked"{/if}>
                    {/if}
                    <label for="wkblog_status_off">{l s='No' mod='wkblogpost'}</label>
                    <a class="slide-button btn"></a>
                </span>
            </div>
        </div>
        <div class="form-group">
    		<label class="control-label col-lg-3">
    			<span title="" data-toggle="tooltip" class="label-tooltip" data-original-title="{l s='Invalid characters <>;=#\{\}' mod='wkblogpost'}">
    				{l s='Meta Title' mod='wkblogpost'}
    			</span>
    		</label>
    		<div class="col-lg-7">
            {foreach from=$languages item=language}
                {assign var="wkblog_meta_title" value="wkblog_meta_title_`$language.id_lang`"}
    			<input type="text" name="wkblog_meta_title_{$language.id_lang}" id="wkblog_meta_title_{$language.id_lang}" value="{if isset($smarty.post.$wkblog_meta_title)}{$smarty.post.$wkblog_meta_title}{else if isset($obj_wkpost)}{$obj_wkpost->meta_title.{$language.id_lang}}{/if}" id="wkcat_meta_title_{$language.id_lang}" class="form-contrl all_wkfield" {if $id_lang != $language.id_lang}style="display:none;"{/if}>
            {/foreach}
    		</div>
             {if $total_languages > 1}
            <div class="col-lg-2">
                <button type="button" id="meta_title_lang_btn" class="btn btn-default dropdown-toggle wklang" data-toggle="dropdown">
                    {$iso}
                    <span class="caret"></span>
                </button>
                <ul class="dropdown-menu">
                    {foreach from=$languages item=language}
                        <li>
                            <a href="javascript:hideOtherLanguage({$language.id_lang});" onclick="showProdLangField('{$language.iso_code}', {$language.id_lang});">{$language.name}</a>
                        </li>
                    {/foreach}
                </ul>
            </div>
            {/if}
    	</div>
        <div class="form-group">
            <label class="control-label col-lg-3">
                <span title="" data-toggle="tooltip" class="label-tooltip" data-original-title="{l s='Invalid characters <>;=#\{\}' mod='wkblogpost'}">
                    {l s='Meta Description' mod='wkblogpost'}
                </span>
            </label>
            <div class="col-lg-7">
            {foreach from=$languages item=language}
                {assign var="wkblog_meta_desc" value="wkblog_meta_desc_`$language.id_lang`"}
                <input type="text" name="wkblog_meta_desc_{$language.id_lang}" id="wkblog_meta_desc_{$language.id_lang}" value="{if isset($smarty.post.$wkblog_meta_desc)}{$smarty.post.$wkblog_meta_desc}{else if isset($obj_wkpost)}{$obj_wkpost->meta_description.{$language.id_lang}}{/if}" class="form-contrl all_wkfield" {if $id_lang != $language.id_lang}style="display:none;"{/if}>
            {/foreach}
            </div>
             {if $total_languages > 1}
            <div class="col-lg-2">
                <button type="button" id="meta_desc_lang_btn" class="btn btn-default dropdown-toggle wklang" data-toggle="dropdown">
                    {$iso}
                    <span class="caret"></span>
                </button>
                <ul class="dropdown-menu">
                    {foreach from=$languages item=language}
                        <li>
                            <a href="javascript:hideOtherLanguage({$language.id_lang});" onclick="showProdLangField('{$language.iso_code}', {$language.id_lang});">{$language.name}</a>
                        </li>
                    {/foreach}
                </ul>
            </div>
            {/if}
        </div>
    	<div class="form-group">
    		<label class="control-label col-lg-3">
    			<span title="" data-toggle="tooltip" class="label-tooltip" data-original-title="{l s='Invalid characters <>;=#\{\}' mod='wkblogpost'}">
    				{l s='Meta Keywords' mod='wkblogpost'}
    			</span>
    		</label>
    		<div class="col-lg-7">
            {foreach from=$languages item=language}
                {assign var="wkblog_meta_keyword" value="wkblog_meta_keyword_`$language.id_lang`"}
                <input type="text" name="wkblog_meta_keyword_{$language.id_lang}" id="wkblog_meta_keyword_{$language.id_lang}" value="{if isset($smarty.post.$wkblog_meta_keyword)}{$smarty.post.$wkblog_meta_keyword}{else if isset($obj_wkpost)}{$obj_wkpost->meta_keyword.{$language.id_lang}}{/if}" id="wkcat_meta_keyword_{$language.id_lang}" class="form-contrl all_wkfield" {if $id_lang != $language.id_lang}style="display:none;"{/if}>
            {/foreach}
            </div>
             {if $total_languages > 1}
            <div class="col-lg-2">
                <button type="button" id="meta_lang_btn" class="btn btn-default dropdown-toggle wklang" data-toggle="dropdown">
                    {$iso}
                    <span class="caret"></span>
                </button>
                <ul class="dropdown-menu">
                    {foreach from=$languages item=language}
                        <li>
                            <a href="javascript:hideOtherLanguage({$language.id_lang});" onclick="showProdLangField('{$language.iso_code}', {$language.id_lang});">{$language.name}</a>
                        </li>
                    {/foreach}
                </ul>
            </div>
            {/if}
    	</div>
        <div class="form-group">
			<label class="control-label col-lg-3 required" for="date">
				<span title="" data-toggle="tooltip" class="label-tooltip" data-original-title="{l s='Set the date' mod='wkblogpost'}">
    				{l s='Publish Date' mod='wkblogpost'}
    			</span>
    		</label>
			<div class="col-lg-4">
				<div class="input-group">
					<span class="input-group-addon"><i class="icon-calendar"></i></span>
					<input id="date" size="20" type="text" value="{if isset($obj_wkpost)}{$obj_wkpost->date_add}{else}{$current_date}{/if}" name="wkpublish_date" class="wkblogdatetimepicker">
				</div>
				<p class="help-block">{l s='Format: YYYY-MM-DD HH:MM:SS' mod='wkblogpost'}</p>
			</div>
		</div>
        <div class="panel-footer">
            <a class="btn btn-default" href="{$link->getAdminLink('AdminWkBlogPost')}">
                <i class="process-icon-cancel"></i>{l s='Cancel' mod='wkblogpost'}
            </a>
            <button class="btn btn-default pull-right" name="submitAdd{$table}" type="submit">
                <i class="process-icon-save"></i>{l s='Save' mod='wkblogpost'}
            </button>
            <button class="btn btn-default pull-right" name="submitAdd{$table}AndStay" type="submit">
                <i class="process-icon-save"></i>{l s='Save and stay' mod='wkblogpost'}
            </button>
        </div>
    </form>

</div>
{strip}
    {addJsDef PS_ALLOW_ACCENTED_CHARS_URL = $ps_allow_accented_chars_url}
{/strip}
<script>
// for tiny mce setup
{* var iso = "{$iso}";
var pathCSS = "{$smarty.const._THEME_CSS_DIR_}";
var ad = "{$ad}";
var dt = new Date(); *}
$(document).ready(function(){
	{block name="autoload_tinyMCE"}
		tinySetup({
			editor_selector :"wkblog_tinymce",
			{* width : 700 *}
		});
	{/block}
});
// datetimepicker of the bootstrap/jquery
$('.wkblogdatetimepicker').datetimepicker({
	dateFormat: 'yy-mm-dd',
	showSecond: true,
	todayBtn: true,
	timeFormat: "hh:mm:ss",
    maxDate: new Date(),
	changeYear: true
});
</script>