{**
* 2010-2021 Webkul.
*
* NOTICE OF LICENSE
*
* All right is reserved,
* Please go through LICENSE.txt file inside our module
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade this module to newer
* versions in the future. If you wish to customize this module for your
* needs please refer to CustomizationPolicy.txt file inside our module for more information.
*
* @author Webkul IN
* @copyright 2010-2021 Webkul IN
* @license LICENSE.txt
*}

{extends file=$layout}
{block name='head_seo_title'}
    {if isset($meta_title)}
        {$meta_title}
    {else}
        {$page.meta.title}
    {/if}
{/block}
{block name='head_seo_description'}
    {if isset($meta_desc)}
        {$meta_desc}
    {else}
        {$page.meta.description}
    {/if}
{/block}
{block name='head_seo_keywords'}
    {if isset($meta_keys)}
        {$meta_keys}
    {else}
        {$page.meta.keywords}
    {/if}
{/block}
{block name='content'}
    <div class="row wkblock">
        {if !empty($listing_posts)}
            <div class="col-md-8 col-xs-12 col-sm-12 wk_shadow_box">
                {if isset($category_content)}
                    {assign var="path" value ="{$module_path}wkblogpost/views/img/category/{$category_content.id_wk_blogpost_category}_cat.jpg"}
                    {if file_exists($path)}
                        <div class="clearfix">
                            <img
                                src="{$ps_module_dir}wkblogpost/views/img/category/{$category_content.id_wk_blogpost_category|intval}_cat.jpg" width="100%"/>
                        </div>
                    {/if}
                    {if isset($category_content) && !empty($category_content.description)}
                        <div class="clearfix" style="margin-bottom:20px;">
                            <p>{$category_content.description|strip_tags:true}</p>
                        </div>
                    {/if}
                {/if}
                {foreach $listing_posts as $key => $post}
                    <div class="clearfix post_1 wkbox">
                        <div class="wk-list-category-name">
                            <span><a href="{$link->getModuleLink('wkblogpost', 'categorypost', ['cat' => {$post.cat_link_rewrite}])}">{$post.cat_title|ucfirst}</a></span>
                        </div>
                        <div class="col-sm-3 featuredimage">
                            <div class="clearfix blog-featured-img">
                                {assign var="path" value="{$module_path}wkblogpost/views/img/blog/{$post.id_wk_blog_post|intval}/{$post.id_wk_blog_post|intval}_blog_thumbnail.jpg"}
                                 {if file_exists($path)}
                                    <img
                                        class="blog_featured_img"
                                        src="{$ps_module_dir}wkblogpost/views/img/blog/{$post.id_wk_blog_post|intval}/{$post.id_wk_blog_post|intval}_blog_thumbnail.jpg?time={$time}"/>
                                {else}
                                    {assign var="custom_img_path" value="{$module_path}wkblogpost/views/img/default/custom-default.jpg"}
                                    {if file_exists($custom_img_path)}
                                        <img
                                        class="blog_featured_img"
                                        src="{$ps_module_dir}wkblogpost/views/img/default/custom-default.jpg"/>
                                    {else}
                                        <img
                                            class="blog_featured_img"
                                            src="{$ps_module_dir}wkblogpost/views/img/default/home-default.png"/>
                                    {/if}
                                {/if}
                            </div>
                        </div>
                        <div class="col-sm-9">
                            <div class="clearfix wk_title_head">
                                <h1 class="wkblog-list-heading">
                                    <a href="{$link->getModuleLink('wkblogpost', 'readmore', ['post' => {$post.link_rewrite|replace:' ':'-'}])}" title="{$post.title}">
                                        {$post.title|truncate:65:'...':true}
                                    </a>
                                </h1>
                                <div class="clearfix blog-content">
                                    <p>{$post.description|strip_tags:true|truncate:0:'...':true}</p>
                                </div>
                            </div>
                            <div class="clearfix user_info">
                                {if Configuration::get('WK_SHOW_AUTHOR_THUMBNAIL')}
                                    <div class="clearfix wkblog_list_info">
                                        {assign var="path" value ="{$module_path}wkblogpost/views/img/default/custom-autor-profile.jpg"}
                                    </div>
                                    {if file_exists($path)}
                                        <div class="clearfix wk_left wk_profile_img">
                                            <img
                                                class="wk-image-responsive"
                                                src="{$ps_module_dir}wkblogpost/views/img/default/custom-autor-profile.jpg"/>
                                        </div>
                                    {else}
                                        <div class="clearfix wk_left wk_profile_img">
                                            <img
                                                class="wk-image-responsive"
                                                src="{$ps_module_dir}wkblogpost/views/img/default/autor-profile.jpg"/>
                                        </div>
                                    {/if}
                                    <div class="clearfix wk_user_info wk_left">
                                        <span>{Configuration::get('WK_BLOG_POST_AUTHOR_NAME')}</span>
                                        <div>
                                            <span>{$post.date_add|date_format:"%B %e, %Y"}</span>
                                        </div>
                                    </div>
                                {else}

                                {/if}
                            </div>
                        </div>
                    </div>
                {/foreach}
                <ul class="pager">
                    {if isset($previous_page) && $previous_page != 0}
                        <li class="previous">
                            {if $controller == 'categorypost'}
                                <a href="{$link->getModuleLink('wkblogpost', {$controller}, ['cat' => {$category}])}?page={$previous_page}">{l s='Previous' mod='wkblogpost'} &larr;</a>
                            {else if $controller == 'search'}
                                <a href="{$link->getModuleLink('wkblogpost', {$controller}, ['q' => {$string}])}&page={$previous_page}">{l s='Previous' mod='wkblogpost'} &larr;</a>
                            {else}
                                <a href="{$link->getModuleLink('wkblogpost', {$controller|escape:'html':'UTF-8'}, ['page' => {$previous_page|escape:'htmlall':'UTF-8'}])|escape:'htmlall':'UTF-8'}">&larr;
                                    {l s='Previous' mod='wkblogpost'}
                                </a>
                            {/if}
                        </li>
                    {/if}
                    {if isset($pagination)}
                        <li class="next">
                            {if $controller == 'categorypost'}
                                <a href="{$link->getModuleLink('wkblogpost', {$controller}, ['cat' => {$category}])}?page={$next_page}">{l s='Next' mod='wkblogpost'} &rarr;</a>
                            {else if $controller == 'search'}
                                <a href="{$link->getModuleLink('wkblogpost', {$controller}, ['q' => {$string}])}&page={$next_page}">{l s='Next' mod='wkblogpost'} &rarr;</a>
                            {else}
                                <a href="{$link->getModuleLink('wkblogpost', {$controller|escape:'html':'UTF-8'}, ['page' => {$next_page|escape:'htmlall':'UTF-8'}])|escape:'htmlall':'UTF-8'}">
                                    {l s='Next' mod='wkblogpost'} &rarr;
                                </a>
                            {/if}
                        </li>
                    {/if}
                </ul>
            </div>
        {else}
            {include file="module:wkblogpost/views/templates/front/wk_no_found.tpl"}
        {/if}
        <div class="col-xs-12 col-sm-12 col-md-4">
            <div id="search_block_top">
                <form method="get" action="{$link->getModuleLink('wkblogpost', 'search')}">
                    {if !$wk_rewrite_enabled}
                        <input type="hidden" name="fc" value="module"/>
                        <input type="hidden" name="module" value="wkblogpost"/>
                        <input type="hidden" name="controller" value="search"/>
                    {/if}
                    <div class="clearfix wkblog_search block-categories">
                        <input
                            type="text"
                            value=""
                            placeholder="{l s='Pesquisa Blog' mod='wkblogpost'}"
                            name="q"
                            class="form-control"
                            autocomplete="off">
                        <button
                            type="submit">
                            <i class="material-icons search"></i>
                        </button>
                    </div>
                </form>
            </div>
            {if isset($category_on) && $category_on == 1}
                <div class="wk-recent-blog wkbox wk_post_category clearfix wk_shadow_box">
                    <div class="wktitle">
                        <span>{l s='Categorias Blog' mod='wkblogpost'}</span>
                    </div>
                    <hr>
                    {if !empty($all_category)}
                        {foreach $all_category as $key => $cat}
                            {if $key+1 <= $no_cat}
                                <div class="wkcontent">
                                    <h3>
                                        <a
                                            {if isset($post_content)}
                                            {if $cat.title == $post_content.cat_title}
                                            class="active"
                                            {/if}
                                            {/if}
                                            href="{$link->getModuleLink('wkblogpost', 'categorypost', ['cat' => {$cat.link_rewrite}])}">{$cat.title}</a>
                                    </h3>
                                </div>
                            {/if}
                        {/foreach}
                    {else}
                        <div class="wkcontent">
                            <h4>{l s='Categoria não encontrada' mod='wkblogpost'}</h4>
                        </div>
                    {/if}
                </div>
            {/if}
        </div>
    </div>
    <div class="row">
        <div class="col-md-12">
            <hr>

        </div>
    </div>
{/block}