<?php
/**
* 2010-2021 Webkul.
*
* NOTICE OF LICENSE
*
* All right is reserved,
* Please go through LICENSE.txt file inside our module
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade this module to newer
* versions in the future. If you wish to customize this module for your
* needs please refer to CustomizationPolicy.txt file inside our module for more information.
*
* @author Webkul IN
* @copyright 2010-2021 Webkul IN
* @license LICENSE.txt
*/

if (!defined('_PS_VERSION_')) {
    exit;
}
require_once 'classes/WkBlogPostClassInclude.php';

class WkBlogPost extends Module
{
    public function __construct()
    {
        $this->name = 'wkblogpost';
        $this->tab = 'front_office_features';
        $this->version = '4.0.0';
        $this->author = 'Webkul';
        $this->need_instance = 0;
        $this->bootstrap = true;
        $this->secure_key = Tools::encrypt($this->name);
        $this->ps_versions_compliancy = array('min' => '1.7', 'max' => _PS_VERSION_);
        parent::__construct();
        $this->absoluteBlogPath = _PS_MODULE_DIR_.'wkblogpost/views/img/blog/';
        $this->absoluteCatPath = _PS_MODULE_DIR_.'wkblogpost/views/img/category/';
        $this->displayName = $this->l('Blog Post');
        $this->description = $this->l('By using this module admin can create and share attractive blogs to your shop');
        $this->confirmUninstall = $this->l('Are you sure you want to uninstall this module?');
    }

    public function installTab($class_name, $tab_name, $tab_parent_name = false)
    {
        $tab = new Tab();
        $tab->active = 1;
        $tab->class_name = $class_name;
        $tab->name = array();
        if ($class_name == 'AdminWkBlog') {
            $tab->icon = 'book';
        }

        foreach (Language::getLanguages(true) as $lang) {
            $tab->name[$lang['id_lang']] = $this->l($tab_name);
        }

        if ($tab_parent_name) {
            $tab->id_parent = (int) Tab::getIdFromClassName($tab_parent_name);
        } else {
            $tab->id_parent = 0;
        }

        $tab->module = $this->name;

        return $tab->add();
    }

    public function callInstallTab()
    {
        $this->installTab('AdminManageBlog', 'Manage Blog');
        $this->installTab('AdminWkBlog', 'Blog Post', 'AdminManageBlog');
        $this->installTab('AdminWkBlogPostConfiguration', 'Configuration', 'AdminWkBlog');
        $this->installTab('AdminWkBlogPost', 'Posts', 'AdminWkBlog');
        $this->installTab('AdminWkCategoryPost', 'Category', 'AdminWkBlog');
        return true;
    }

    public function registerPsHooks()
    {
        $hooks = array(
            'displayNav1',
            'moduleRoutes',
            'displayMyAccountBlock'
        );
        return $this->registerHook($hooks);
    }

    public function hookModuleRoutes()
    {
        return array(
            'module-wkblogpost-blogpost' => array(
                    'controller' => 'blogpost',
                    'rule' => 'blogpost/',
                    'keywords' => array(),
                    'params' => array(
                        'fc' => 'module',
                        'module' => 'wkblogpost',
                        'controller' => 'blogpost',
                    ),
            ),
            'module-wkblogpost-readmore' => array(
                'controller' => 'readmore',
                'rule' => 'blogpost/{:post}',
                'keywords' => array(
                    'post' => array(
                    'regexp' => '[_a-zA-Z0-9_-]+',
                    'param' => 'post',
                    ),
                ),
                'params' => array(
                    'fc' => 'module',
                    'module' => 'wkblogpost',
                    'controller' => 'readmore',
                ),
            ),
            'module-wkblogpost-categorypost' => array(
                'controller' => 'categorypost',
                'rule' => 'categorypost/{:cat}',
                'keywords' => array(
                    'cat' => array(
                    'regexp' => '[_a-zA-Z0-9_-]+',
                    'param' => 'cat',
                    ),
                ),
                'params' => array(
                    'fc' => 'module',
                    'module' => 'wkblogpost',
                    'controller' => 'categorypost',
                ),
            ),
        );
    }

    public function hookDisplayMyAccountBlock()
    {
        $this->context->smarty->assign(
            array(
                'wk_psb_footer' => 1,
                'blogLink' => $this->context->link->getModuleLink(
                    $this->name,
                    'blogpost'
                )
            )
        );
        return $this->context->smarty->fetch(
            _PS_MODULE_DIR_.$this->name.'/views/templates/hook/blog_link.tpl'
        );
    }

    public function hookDisplayNav1()
    {
        $this->context->smarty->assign(
            array(
                'wk_psb_nav' => 1,
                'blogLink' => $this->context->link->getModuleLink(
                    $this->name,
                    'blogpost'
                )
            )
        );
        return $this->context->smarty->fetch(
            _PS_MODULE_DIR_.$this->name.'/views/templates/hook/blog_link.tpl'
        );
    }

    /**
     * Adding a default category when module will install,
     * this category will be default
     *
     * @return void
     */
    public function addDefaultCategory()
    {
        $obj_wkcat = new WkBlogPostCategory();
        $obj_wkcat->active = 1;
        $obj_wkcat->is_default = 1;
        foreach (Language::getLanguages(true) as $language) {
            $obj_wkcat->title[$language['id_lang']] = $this->l('Uncategorized');
            $obj_wkcat->link_rewrite[$language['id_lang']] = $this->l('Uncategorized');
        }
        $obj_wkcat->save();

        return true;
    }

    public function install()
    {
        if (Shop::isFeatureActive()) {
            Shop::setContext(Shop::CONTEXT_ALL);
        }
        $db = new WkSelectMultiShopDb();
        if (!parent::install()
            || !$this->callInstallTab()
            || !$db->createTable()
            || !$this->registerPsHooks()
            || !$this->addDefaultCategory()
        ) {
            return false;
        }
        Configuration::updateValue('WK_NO_OF_BLOG_POST', 4);
        Configuration::updateValue('WK_NO_OF_BLOG_CATEGORY', 4);
        Configuration::updateValue('WK_BLOG_CATEGORY_ON', 1);
        Configuration::updateValue('WK_BLOG_POST_AUTHOR_NAME', 'Admin');
        return true;
    }

    /**
     * Redirecting to configuration controller to manage all the configuration of the module
     *
     * @return void
     */
    public function getContent()
    {
        Tools::redirectAdmin($this->context->link->getAdminLink('AdminWkBlogPostConfiguration'));
    }

    public function uninstallTab()
    {
        $moduleTabs = Tab::getCollectionFromModule($this->name);
        if (!empty($moduleTabs)) {
            foreach ($moduleTabs as $moduleTab) {
                $moduleTab->delete();
            }
        }

        return true;
    }

    public static function deleteDir($dirPath)
    {
        if (is_dir($dirPath)) {
            if (Tools::substr($dirPath, Tools::strlen($dirPath) - 1, 1) != '/') {
                $dirPath .= '/';
            }
            $files = glob($dirPath . '*', GLOB_MARK);
            foreach ($files as $file) {
                if (is_dir($file)) {
                    self::deleteDir($file);
                } else {
                    unlink($file);
                }
            }
            rmdir($dirPath);
        }
    }

    public function unlinkImage()
    {
        $obj_wkblog = new WkBlogPostData();
        $obj_wkcat = new WkBlogPostCategory();
        $id_lang = $this->context->language->id;
        $all_blog = $obj_wkblog->getAllBlogs($id_lang);
        $all_cat = $obj_wkcat->getAllCategories($id_lang);
        if ($all_blog) {
            foreach ($all_blog as $blog) {
                $this->deleteDir($this->absoluteBlogPath.$blog['id_wk_blog_post']);
            }
        }
        if ($all_cat) {
            foreach ($all_cat as $cat) {
                $path = $this->absoluteCatPath.$cat['id_wk_blogpost_category'].'_cat.jpg';
                if (file_exists($path)) {
                    unlink($path);
                }
            }
        }

        return true;
    }

    public function uninstall()
    {
        $db = new WkSelectMultiShopDb();
        if (parent::uninstall() == false
            || !$this->uninstallTab()
            || !$this->unlinkImage()
            || !$db->deleteTables()
        ) {
            return false;
        }

        return true;
    }
}
