/**
* 2013 - 2018 HiPresta
*
* MODULE Add to cart button
*
* @author    HiPresta <suren.mikaelyan@gmail.com>
* @copyright HiPresta 2018
* @license   Addons PrestaShop license limitation
* @link      http://www.hipresta.com
*
* NOTICE OF LICENSE
*
* Don't use this module on several shops. The license provided by PrestaShop Addons
* for all its modules is valid only once for a single shop.
*/

$(document).ready(function() {
	
	$(document).on('click', '.hiaddtocart button ', function(e){
        e.preventDefault();
    });
    createQuantitySpin();
});

function createQuantitySpin() {
	$('.hi-quantity').each(function(){
		var quantityInput = $(this);
	    quantityInput.TouchSpin({
	      verticalbuttons: true,
	      verticalupclass: 'material-icons touchspin-up',
	      verticaldownclass: 'material-icons touchspin-down',
	      buttondown_class: 'btn btn-touchspin js-touchspin',
	      buttonup_class: 'btn btn-touchspin js-touchspin',
	      min: parseInt(quantityInput.attr('min'), 10),
	      max: 1000000
	    });

	    quantityInput.on('change', function (event) {
	      let $productRefresh = $('.product-refresh');
	      $(event.currentTarget).trigger('touchspin.stopspin');
	      $productRefresh.trigger('click', {eventType: 'updatedProductQuantity'});
	      event.preventDefault();

	      return false;
	    });
	});
}