<?php


class AdminStoreCommanderPsController extends ModuleAdminController
{

    public function __construct()
    {
        $this->display = 'view';
        $this->multishop_context = false;
        $this->multishop_context_group = false;
        parent::__construct();
    }

    private function findSCFolder()
    {
        $dir = dirname(__FILE__) . "/../../";
        if (is_dir($dir)) {
            $objects = scandir($dir);
            foreach ($objects as $object) {
                if (is_dir($dir . '/' . $object) && Tools::strlen(basename($object)) == 11 && basename($object) != "controllers") {
                    return basename($object);
                }
            }
        }
        return false;
    }

    public function renderView()
    {
        $cookie = Context::getContext()->cookie;

        $this->addCSS(__PS_BASE_URI__.'modules/storecommanderps/views/css/admin.css', 'all');
        $sc_title = "";
        $sc_url = "";
        //
        // Login as selected user on the front office
        // Fix connection for specific 1.5 shops
        //
        $_html = "";
        if(version_compare(_PS_VERSION_, '1.7.0.0', '>=') && Tools::getIsset("REDIRECTADMIN")){
            $subaction = Tools::getValue('subaction',"catalog");
            if($subaction=="addproduct")
            {
                global $kernel; // sf kernel
                if ($kernel instanceof Symfony\Component\HttpKernel\HttpKernelInterface) {
                    $sfRouter = $kernel->getContainer()->get('router');
                }
                $url_redir = $sfRouter->generate('admin_product_new');
            }
            else
            {
                $urlParams = Tools::getValue('urlParams',array());
                $anchor = "";
                if(!empty($urlParams["anchor"]))
                {
                    $anchor = $urlParams["anchor"];
                    unset($urlParams["anchor"]);
                }
                $link = new Link();
                $url_redir = $link->getAdminLink($subaction, true, $urlParams).$anchor;
            }
            if(!empty($url_redir))
            {
                header("location: ".(Configuration::get('PS_SSL_ENABLED') ? _PS_BASE_URL_SSL_ : _PS_BASE_URL_).$url_redir);
            }
        }else {
            $currentFileName = array_reverse(explode("/", $_SERVER['SCRIPT_NAME']));
            $psadminpath = $currentFileName[1];
            $datelastregen = Db::getInstance()->getValue('SELECT last_passwd_gen FROM ' . _DB_PREFIX_ . 'employee WHERE id_employee=' . (int)($cookie->id_employee));
            $scdir = $this->findSCFolder();
            if ($scdir === false) {
                $this->context->controller->errors[] = 'Unable to find the Store Commander folder. Please contact <a href="support.storecommander.com" targe="_blank">support.storecommander.com</a>';
            } else {
                $sc_title = "Loading...";
                $sc_url = '../modules/storecommanderps/' . $scdir . '/SC/index.php?ide=' . $cookie->id_employee . '&psap=' . $psadminpath . '&key=' . md5($cookie->id_employee . $datelastregen);
            }
        }
        $this->tpl_view_vars = array(
            'html' => $_html,
            'sc_url' => $sc_url,
            'sc_title' => $sc_title
        );
        return parent::renderView();
    }
}
