<?php
/**
* 2010-2021 Webkul.
*
* NOTICE OF LICENSE
*
* All right is reserved,
* Please go through LICENSE.txt file inside our module
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade this module to newer
* versions in the future. If you wish to customize this module for your
* needs please refer to CustomizationPolicy.txt file inside our module for more information.
*
* @author Webkul IN
* @copyright 2010-2021 Webkul IN
* @license LICENSE.txt
*/

class WkBlogPostData extends ObjectModel
{
    public $id_category;
    public $active;
    public $date_add;
    public $date_upd;

    public $title;
    public $link_rewrite;
    public $description;
    public $meta_title;
    public $meta_keyword;
    public $meta_description;

    public static $definition = array(
        'table' => 'wk_blog_post',
        'primary' => 'id_wk_blog_post',
        'multilang' => true,
        'multilang_shop' => true,
        'fields' => array(
            'id_category' => array(
                'type' => self::TYPE_INT,
                'validate' => 'isUnsignedInt',
                'required' => true,
                'shop' => true
            ),
            'active' => array('type' => self::TYPE_BOOL,'validate' => 'isBool', 'shop' => true),
            'date_add' => array('type' => self::TYPE_DATE, 'validate' => 'isDateFormat', 'shop' => true),
            'date_upd' => array('type' => self::TYPE_DATE, 'validate' => 'isDateFormat', 'shop' => true),

            //multi lang
            'title' => array('type' => self::TYPE_STRING, 'required' => true, 'lang' => true),
            'link_rewrite' => array('type' => self::TYPE_STRING, 'required' => true, 'lang' => true),
            'description' => array('type' => self::TYPE_HTML, 'required' => true,
            'lang' => true),
            'meta_title' => array('type' => self::TYPE_STRING, 'lang' => true),
            'meta_keyword' => array('type' => self::TYPE_STRING, 'lang' => true),
            'meta_description' => array('type' => self::TYPE_STRING, 'lang' => true, 'validate' => 'isCleanHtml'),

        ),
    );

    public function __construct($id = null, $idLang = null, $idShop = null)
    {
        parent::__construct($id, $idLang, $idShop);
        Shop::addTableAssociation('wk_blog_post', array('type' => 'shop', 'primary' => 'id_wk_blog_post'));
        Shop::addTableAssociation('wk_blog_post_lang', array('type' => 'fk_shop', 'primary' => 'id_wk_blog_post'));
    }

    public function getActivePostByCategoryId($id_category, $id_lang)
    {
        $sql = 'SELECT * FROM `'._DB_PREFIX_.'wk_blog_post` wkpost
			LEFT JOIN `'._DB_PREFIX_.'wk_blog_post_lang` wkpostlang
            ON (wkpost.`id_wk_blog_post` = wkpostlang.`id_wk_blog_post`)';
        $sql .= Shop::addSqlAssociation('wk_blog_post', 'wkpost');
        $sql .= ' where `id_lang` = '.(int) $id_lang.' AND wk_blog_post_shop.`active` = 1
        AND wk_blog_post_shop.`id_category` = '.(int) $id_category;
        $sql .= Shop::addSqlRestrictionOnLang('wkpostlang');
        $result = Db::getInstance()->executeS($sql);
        // dump($result);die;
        if ($result) {
            return $result;
        } else {
            return false;
        }
    }

    public function getActivePostByCategoryIdWithLimit($id_category, $id_lang, $limit)
    {
        $sql = 'SELECT
        wkpost.*,
        wkpostlang.*,
        wkpostcat.`is_default` as cat_is_default,
        wkpostcat.`date_add` as cat_date_add,
        wkpostcat.`date_upd` as cat_date_upd,
        wkpostcat.`active` as cat_active,
        wkpostcatlang.`title` as cat_title,
        wkpostcatlang.`link_rewrite` as cat_link_rewrite,
        wkpostcatlang.`meta_title` as cat_meta_title,
        wkpostcatlang.`meta_keyword` as cat_meta_keyword,
        wkpostcatlang.`meta_description` as cat_meta_description,
        wkpostcatlang.`description` as cat_description FROM `'._DB_PREFIX_.'wk_blog_post` wkpost
        LEFT JOIN `'._DB_PREFIX_.'wk_blog_post_lang` wkpostlang
        ON (wkpost.`id_wk_blog_post` = wkpostlang.`id_wk_blog_post`)
        JOIN `'._DB_PREFIX_.'wk_blogpost_category` wkpostcat
        ON (wkpostcat.`id_wk_blogpost_category` = wkpost.`id_category`)
        JOIN `'._DB_PREFIX_.'wk_blogpost_category_lang` wkpostcatlang
        ON (wkpostcat.`id_wk_blogpost_category` = wkpostcatlang.`id_wk_blogpost_category`)';
        $sql .= Shop::addSqlAssociation('wk_blog_post', 'wkpost');
        $sql .= Shop::addSqlAssociation('wk_blogpost_category', 'wkpostcat');
        $sql .= ' WHERE
            wkpostlang.`id_lang` = '.(int) $id_lang.' AND
            wkpostcatlang.`id_lang` = '.(int) $id_lang.' AND
            wk_blog_post_shop.`active` = 1 AND
            wk_blog_post_shop.`id_category` = '.(int) $id_category;
        $sql .= Shop::addSqlRestrictionOnLang('wkpostlang');
        $sql .= Shop::addSqlRestrictionOnLang('wkpostcatlang');
        $sql .= ' order by `date_add` desc LIMIT '.$limit;
        return Db::getInstance()->executeS(
            $sql
        );
    }

    public function getCatIds()
    {
        $sql = 'SELECT wk_blog_post_shop.`id_category` FROM `'._DB_PREFIX_.'wk_blog_post` wkpost';
        $sql .= Shop::addSqlAssociation('wk_blog_post', 'wkpost');
        $sql .= ' GROUP BY `id_category`';
        $result = Db::getInstance()->executeS($sql);
        if ($result) {
            return $result;
        } else {
            return false;
        }
    }

    public function getAllBlogs($id_lang)
    {
        $sql = 'SELECT * FROM `'._DB_PREFIX_.'wk_blog_post` wkpost
			LEFT JOIN `'._DB_PREFIX_.'wk_blog_post_lang` wkpostlang
            on (wkpost.`id_wk_blog_post` = wkpostlang.`id_wk_blog_post`)';
        $sql .= Shop::addSqlAssociation('wk_blog_post', 'wkpost');
        $sql .= ' where `id_lang` = '.(int) $id_lang;
        $sql .= Shop::addSqlRestrictionOnLang('wkpostlang');
        $result = Db::getInstance()->executeS($sql);
        if ($result) {
            return $result;
        } else {
            return false;
        }
    }

    public function getActivePostId($id_lang)
    {
        $sql = 'SELECT wbp.*, wbplang.* FROM `'._DB_PREFIX_.'wk_blog_post` wbp
        LEFT JOIN `'._DB_PREFIX_.'wk_blog_post_lang` wbplang on (wbp.`id_wk_blog_post` = wbplang.`id_wk_blog_post`)
        JOIN `'._DB_PREFIX_.'wk_blogpost_category` wkpostcategory
        on (wbp.`id_category` = wkpostcategory.`id_wk_blogpost_category`)';
        $sql .= Shop::addSqlAssociation('wk_blog_post', 'wbp');
        $sql .= Shop::addSqlAssociation('wk_blogpost_category', 'wkpostcategory');
        $sql .= ' where `id_lang` = '.(int) $id_lang.' AND wk_blog_post_shop.`active` = 1
        AND wk_blogpost_category_shop.`active` = 1';
        $sql .= Shop::addSqlRestrictionOnLang('wbplang');
        $sql .= ' order by wbp.`date_add` desc';
        $result = Db::getInstance()->executeS(
            $sql
        );
        if ($result) {
            return $result;
        } else {
            return false;
        }
    }

    public function getActivePostByLangIdWithLimit($id_lang, $limit, $idblogs = false)
    {
        $sql = 'SELECT
            wkpost.*,
            wkpostlang.*,
            wkpostcat.`is_default` as cat_is_default,
            wkpostcat.`date_add` as cat_date_add,
            wkpostcat.`date_upd` as cat_date_upd,
            wkpostcat.`active` as cat_active,
            wkpostcatlang.`title` as cat_title,
            wkpostcatlang.`link_rewrite` as cat_link_rewrite,
            wkpostcatlang.`meta_title` as cat_meta_title,
            wkpostcatlang.`meta_keyword` as cat_meta_keyword,
            wkpostcatlang.`meta_description` as cat_meta_description,
            wkpostcatlang.`description` as cat_description FROM `'._DB_PREFIX_.'wk_blog_post` wkpost
			JOIN `'._DB_PREFIX_.'wk_blog_post_lang` wkpostlang
            ON (wkpost.`id_wk_blog_post` = wkpostlang.`id_wk_blog_post`)
            JOIN `'._DB_PREFIX_.'wk_blogpost_category` wkpostcat
            ON (wkpostcat.`id_wk_blogpost_category` = wkpost.`id_category`)
            JOIN `'._DB_PREFIX_.'wk_blogpost_category_lang` wkpostcatlang
            ON (wkpostcat.`id_wk_blogpost_category` = wkpostcatlang.`id_wk_blogpost_category`)';
        $sql .= Shop::addSqlAssociation('wk_blog_post', 'wkpost');
        $sql .= Shop::addSqlAssociation('wk_blogpost_category', 'wkpostcat');
        $sql .= ' WHERE
                    wkpostlang.`id_lang` = '.(int) $id_lang.' AND
                    wkpostcatlang.`id_lang` = '.(int) $id_lang.' AND
                    wk_blogpost_category_shop.`active` = 1 AND
                    wk_blog_post_shop.`active` = 1 ';

        if ($idblogs) {
            $sql .= ' AND wk_blog_post_shop.`id_wk_blog_post` IN ('.pSQL($idblogs).')';
        }
        $sql .= Shop::addSqlRestrictionOnLang('wkpostlang');
        $sql .= Shop::addSqlRestrictionOnLang('wkpostcatlang');
        $sql .= ' ORDER BY wk_blog_post_shop.`date_add` desc LIMIT '. $limit;
        // dump(Db::getInstance()->executeS($sql));die;
        return Db::getInstance()->executeS($sql);
    }

    public function getBlogWithId($idBlog, $idLang)
    {
        $sql = 'SELECT
        wkpost.*,
        wkpostlang.*,
        wkpostcat.`is_default` as cat_is_default,
        wkpostcat.`date_add` as cat_date_add,
        wkpostcat.`date_upd` as cat_date_upd,
        wkpostcat.`active` as cat_active,
        wkpostcatlang.`title` as cat_title,
        wkpostcatlang.`link_rewrite` as cat_link_rewrite,
        wkpostcatlang.`meta_title` as cat_meta_title,
        wkpostcatlang.`meta_keyword` as cat_meta_keyword,
        wkpostcatlang.`meta_description` as cat_meta_description,
        wkpostcatlang.`description` as cat_description  FROM `'._DB_PREFIX_.'wk_blog_post` wkpost
        LEFT JOIN `'._DB_PREFIX_.'wk_blog_post_lang` wkpostlang
        JOIN `'._DB_PREFIX_.'wk_blogpost_category` wkpostcat
        ON (wkpostcat.`id_wk_blogpost_category` = wkpost.`id_category`)
        JOIN `'._DB_PREFIX_.'wk_blogpost_category_lang` wkpostcatlang
        ON (wkpostcat.`id_wk_blogpost_category` = wkpostcatlang.`id_wk_blogpost_category`)
        ON (wkpost.`id_wk_blog_post` = wkpostlang.`id_wk_blog_post`)';
        $sql .= Shop::addSqlAssociation('wk_blog_post', 'wkpost');
        $sql .= Shop::addSqlAssociation('wk_blogpost_category', 'wkpostcat');
        $sql .= ' WHERE wkpostlang.`id_lang` = '.(int) $idLang.'
        AND wkpostcat.`active` = 1
        AND wkpost.`id_wk_blog_post` = '.(int)$idBlog;
        $sql .= Shop::addSqlRestrictionOnLang('wkpostlang');
        $sql .= Shop::addSqlRestrictionOnLang('wkpostcatlang');

        $result = Db::getInstance()->getRow(
            $sql
        );
        return $result;
    }

    public function getPostByString($post, $id_lang, $active = false)
    {
        $sql = 'SELECT
            wkpost.*,
            wkpostlang.*,
            wkpostcat.`is_default` as cat_is_default,
            wkpostcat.`date_add` as cat_date_add,
            wkpostcat.`date_upd` as cat_date_upd,
            wkpostcat.`active` as cat_active,
            wkpostcatlang.`title` as cat_title,
            wkpostcatlang.`link_rewrite` as cat_link_rewrite,
            wkpostcatlang.`meta_title` as cat_meta_title,
            wkpostcatlang.`meta_keyword` as cat_meta_keyword,
            wkpostcatlang.`meta_description` as cat_meta_description,
            wkpostcatlang.`description` as cat_description FROM `'._DB_PREFIX_.'wk_blog_post` wkpost
			LEFT JOIN `'._DB_PREFIX_.'wk_blog_post_lang` wkpostlang
            ON (wkpost.`id_wk_blog_post` = wkpostlang.`id_wk_blog_post`)
            JOIN `'._DB_PREFIX_.'wk_blogpost_category` wkpostcat
            ON (wkpostcat.`id_wk_blogpost_category` = wkpost.`id_category`)
            JOIN `'._DB_PREFIX_.'wk_blogpost_category_lang` wkpostcatlang
            ON (wkpostcat.`id_wk_blogpost_category` = wkpostcatlang.`id_wk_blogpost_category`)';
        $sql .= Shop::addSqlAssociation('wk_blog_post', 'wkpost');
        $sql .= Shop::addSqlAssociation('wk_blogpost_category', 'wkpostcat');
        $sql .= ' WHERE
                    wkpostlang.`id_lang` = '.(int) $id_lang." AND
                    wkpostcat.`active` = 1 AND
                    wkpostlang.`link_rewrite` LIKE '".pSQL($post)."' ";

        if ($active) {
            $sql .= ' AND wk_blog_post_shop.`active` = 1';
        }
        $sql .= Shop::addSqlRestrictionOnLang('wkpostlang');
        $sql .= Shop::addSqlRestrictionOnLang('wkpostcatlang');
        return Db::getInstance()->getRow($sql);
    }

    public function searchBlogByString($str, $id_lang, $start, $end)
    {
        $ids = array();
        $sql = 'SELECT * FROM `'._DB_PREFIX_.'wk_blog_post` wkpost
            LEFT JOIN `'._DB_PREFIX_.'wk_blog_post_lang` wkpostlang
            ON (wkpost.`id_wk_blog_post` = wkpostlang.`id_wk_blog_post`)';
        $sql .= Shop::addSqlAssociation('wk_blog_post', 'wkpost');
        $sql .= ' WHERE
                wkpostlang.`id_lang` = '.(int) $id_lang.' AND
                wk_blog_post_shop.`active` = 1 AND
                (wkpostlang.`title` LIKE \'%'.pSQL($str).'%\')';
        $sql .= Shop::addSqlRestrictionOnLang('wkpostlang');
        $posts = Db::getInstance()->executeS(
            $sql
        );
        if ($posts) {
            foreach ($posts as $post) {
                $ids[] = $post['id_wk_blog_post'];
            }
        }
        $sql = 'SELECT * FROM `'._DB_PREFIX_.'wk_blogpost_category` wkcat
                LEFT JOIN `'._DB_PREFIX_.'wk_blogpost_category_lang` wkcatlang
                ON (wkcat.`id_wk_blogpost_category` = wkcatlang.`id_wk_blogpost_category`)
			    LEFT JOIN `'._DB_PREFIX_.'wk_blog_post` wkpost
                ON (wkpost.`id_category` = wkcat.`id_wk_blogpost_category`)
			    LEFT JOIN `'._DB_PREFIX_.'wk_blog_post_lang` wkpostlang
                ON (wkpost.`id_wk_blog_post` = wkpostlang.`id_wk_blog_post`)';
        $sql .= Shop::addSqlAssociation('wk_blogpost_category', 'wkcat');
        $sql .= Shop::addSqlAssociation('wk_blog_post', 'wkpost');
        $sql .= 'WHERE
                    wkcatlang.`id_lang` = '.(int) $id_lang.' AND
                    wkpostlang.`id_lang` = '.(int) $id_lang.' AND
                    wk_blogpost_category_shop.`active` = 1 AND
                    (wkcatlang.`title` LIKE \'%'.pSQL($str).'%\')';
        $sql .= Shop::addSqlRestrictionOnLang('wkpostlang');
        $sql .= Shop::addSqlRestrictionOnLang('wkcatlang');
        $categories = Db::getInstance()->executeS(
            $sql
        );
        if ($categories) {
            foreach ($categories as $post) {
                $ids[] = $post['id_wk_blogpost_category'];
            }
        }
        $results = array();
        $ids = array_unique($ids);
        $totalPost = count($ids);
        $ids = array_slice($ids, $start, $end, true);   // limit the search as per number of post per page
        if (!empty($ids)) {
            $results = $this->getActivePostByPostId($ids, $id_lang);
        }
        $results['total'] = $totalPost;
        return $results;
    }

    public function getActivePostByPostId($id, $id_lang)
    {
        if (is_array($id)) {
            $id = implode(',', $id);
        }
        $sql = 'SELECT
        wkpost.*,
        wkpostlang.*,
        wkpostcat.`is_default` as cat_is_default,
        wkpostcat.`date_add` as cat_date_add,
        wkpostcat.`date_upd` as cat_date_upd,
        wkpostcat.`active` as cat_active,
        wkpostcatlang.`title` as cat_title,
        wkpostcatlang.`link_rewrite` as cat_link_rewrite,
        wkpostcatlang.`meta_title` as cat_meta_title,
        wkpostcatlang.`meta_keyword` as cat_meta_keyword,
        wkpostcatlang.`meta_description` as cat_meta_description,
        wkpostcatlang.`description` as cat_description  FROM `'._DB_PREFIX_.'wk_blog_post` wkpost
        LEFT JOIN `'._DB_PREFIX_.'wk_blog_post_lang` wkpostlang
        ON (wkpost.`id_wk_blog_post` = wkpostlang.`id_wk_blog_post`)
        JOIN `'._DB_PREFIX_.'wk_blogpost_category` wkpostcat
        ON (wkpostcat.`id_wk_blogpost_category` = wkpost.`id_category`)
        JOIN `'._DB_PREFIX_.'wk_blogpost_category_lang` wkpostcatlang
        ON (wkpostcat.`id_wk_blogpost_category` = wkpostcatlang.`id_wk_blogpost_category`)';
        $sql .= Shop::addSqlAssociation('wk_blogpost_category', 'wkpostcat');
        $sql .= Shop::addSqlAssociation('wk_blog_post', 'wkpost');
        $sql .= ' WHERE
            wkpostlang.`id_lang` = '.(int) $id_lang.' AND
            wkpostcatlang.`id_lang` = '.(int) $id_lang.' AND
            wkpost.`active` = 1 AND
            wkpost.`id_wk_blog_post` IN ('.pSQL($id).')';
        $sql .= Shop::addSqlRestrictionOnLang('wkpostlang');
        $sql .= Shop::addSqlRestrictionOnLang('wkpostcatlang');
        return Db::getInstance()->executeS(
            $sql
        );
    }
}
