<?php
/**
* 2010-2021 Webkul.
*
* NOTICE OF LICENSE
*
* All right is reserved,
* Please go through LICENSE.txt file inside our module
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade this module to newer
* versions in the future. If you wish to customize this module for your
* needs please refer to CustomizationPolicy.txt file inside our module for more information.
*
* @author Webkul IN
* @copyright 2010-2021 Webkul IN
* @license LICENSE.txt
*/

class WkSelectMultiShopDb
{
    public function createTable()
    {
        if ($sql = $this->getModuleSql()) {
            foreach ($sql as $query) {
                if ($query) {
                    if (!DB::getInstance()->execute(trim($query))) {
                        return false;
                    }
                }
            }
        }
        return true;
    }

    public function getModuleSql()
    {
        return array(
            "CREATE TABLE IF NOT EXISTS `"._DB_PREFIX_."wk_blog_post` (
                `id_wk_blog_post` int(10) unsigned NOT NULL auto_increment,
                `id_category` int(11) NOT NULL,
                `active` int(11) NOT NULL,
                `date_add` datetime NOT NULL,
                `date_upd` datetime NOT NULL,
                PRIMARY KEY  (`id_wk_blog_post`)
            ) ENGINE=ENGINE_TYPE DEFAULT CHARSET=utf8",
            "CREATE TABLE IF NOT EXISTS `"._DB_PREFIX_."wk_blog_post_shop` (
                `id_wk_blog_post` int(10) unsigned NOT NULL auto_increment,
                `id_shop` int(10) unsigned NOT NULL,
                `id_category` int(11) NOT NULL,
                `active` int(11) NOT NULL,
                `date_add` datetime NOT NULL,
                `date_upd` datetime NOT NULL,
                PRIMARY KEY  (`id_wk_blog_post`, `id_shop`)
            ) ENGINE=ENGINE_TYPE DEFAULT CHARSET=utf8",
            "CREATE TABLE IF NOT EXISTS `"._DB_PREFIX_."wk_blog_post_lang` (
                `id_wk_blog_post` int(11) NOT NULL auto_increment,
                `id_shop` int(10) unsigned NOT NULL,
                `id_lang` int(11) NOT NULL,
                `title` varchar(255) DEFAULT NULL,
                `description` text,
                `link_rewrite` varchar(255) DEFAULT NULL,
                `meta_title` varchar(255) character set utf8 NOT NULL,
                `meta_keyword` varchar(255) character set utf8 NOT NULL,
                `meta_description` varchar(255) character set utf8 NOT NULL,
                PRIMARY KEY  (`id_wk_blog_post`, `id_lang`, `id_shop`)
            ) ENGINE=ENGINE_TYPE DEFAULT CHARSET=utf8",
            "CREATE TABLE IF NOT EXISTS `"._DB_PREFIX_."wk_blogpost_category` (
                `id_wk_blogpost_category` int(10) unsigned NOT NULL auto_increment,
                `is_default` tinyint(1) unsigned NOT NULL DEFAULT '0',
                `date_add` datetime NOT NULL,
                `date_upd` datetime NOT NULL,
                `active` tinyint(1) unsigned NOT NULL DEFAULT '0',
                PRIMARY KEY  (`id_wk_blogpost_category`)
            ) ENGINE="._MYSQL_ENGINE_." DEFAULT CHARSET=utf8",
            "CREATE TABLE IF NOT EXISTS `"._DB_PREFIX_."wk_blogpost_category_shop` (
                `id_wk_blogpost_category` int(10) unsigned NOT NULL auto_increment,
                `id_shop` int(10) unsigned NOT NULL,
                `is_default` tinyint(1) unsigned NOT NULL DEFAULT '0',
                `date_add` datetime NOT NULL,
                `date_upd` datetime NOT NULL,
                `active` tinyint(1) unsigned NOT NULL DEFAULT '0',
                PRIMARY KEY  (`id_wk_blogpost_category`, `id_shop`)
            ) ENGINE="._MYSQL_ENGINE_." DEFAULT CHARSET=utf8",
            "CREATE TABLE IF NOT EXISTS `"._DB_PREFIX_."wk_blogpost_category_lang` (
                `id_wk_blogpost_category` int(10) unsigned NOT NULL auto_increment,
                `id_shop` int(10) unsigned NOT NULL,
                `id_lang` int(10) unsigned NOT NULL,
                `title` varchar(255) character set utf8 NOT NULL,
                `link_rewrite` varchar(255) character set utf8 NOT NULL,
                `description` text,
                `meta_title` varchar(255) character set utf8 NOT NULL,
                `meta_keyword` varchar(255) character set utf8 NOT NULL,
                `meta_description` text,
                PRIMARY KEY (`id_wk_blogpost_category`, `id_lang`, `id_shop`)
            ) ENGINE="._MYSQL_ENGINE_." DEFAULT CHARSET=utf8",
        );
    }

    public function deleteTables()
    {
        return DB::getInstance()->execute('
            DROP TABLE IF EXISTS
            `'._DB_PREFIX_.'wk_blog_post`,
            `'._DB_PREFIX_.'wk_blog_post_shop`,
            `'._DB_PREFIX_.'wk_blog_post_lang`,
            `'._DB_PREFIX_.'wk_blogpost_category`,
            `'._DB_PREFIX_.'wk_blogpost_category_shop`,
            `'._DB_PREFIX_.'wk_blogpost_category_lang`
        ');
    }
}
