<?php
/**
* 2010-2021 Webkul.
*
* NOTICE OF LICENSE
*
* All right is reserved,
* Please go through LICENSE.txt file inside our module
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade this module to newer
* versions in the future. If you wish to customize this module for your
* needs please refer to CustomizationPolicy.txt file inside our module for more information.
*
* @author Webkul IN
* @copyright 2010-2021 Webkul IN
* @license LICENSE.txt
*/

class AdminWkBlogPostController extends ModuleAdminController
{
    public function __construct()
    {
        $this->identifier = 'id_wk_blog_post';
        $context = Context::getContext();
        $id_lang = (int) $context->language->id;
        $this->table = 'wk_blog_post';
        $this->className = 'WkBlogPostData';
        $this->bootstrap = true;
        parent::__construct();
        if (Shop::getContext() == Shop::CONTEXT_SHOP) {
            Shop::addTableAssociation('wk_blog_post', array('type' => 'shop', 'primary' => 'id_wk_blog_post'));
        }
        $this->_join .= Shop::addSqlAssociation('wk_blog_post', 'a', false);
        $this->_group = ' GROUP BY a.id_wk_blog_post';
        $this->_join .= 'LEFT JOIN `'._DB_PREFIX_.'wk_blog_post_lang` wbpl
        ON (wbpl.`id_wk_blog_post` = a.`id_wk_blog_post`)';
        $this->_join .=
        'LEFT JOIN `'._DB_PREFIX_.'wk_blogpost_category_lang` wkpscatlg
        ON (wkpscatlg.`id_wk_blogpost_category` = a.`id_category`)';
        $this->_select = 'wbpl.`title`, wbpl.`link_rewrite`,  wkpscatlg.`title` as `cat_name`,
        wbpl.`description` as `descr`';
        if (Shop::getContext() == Shop::CONTEXT_SHOP) {
            $this->_select .= ', wk_blog_post_shop.`active`';
        }
        $this->_where = 'AND wbpl.`id_lang` = '.(int) $id_lang.' AND wkpscatlg.`id_lang` = '.(int) $id_lang;
        $this->absolutePath = _PS_MODULE_DIR_.'wkblogpost/views/img/blog/';

        $this->_where .= ' AND wbpl.`id_shop`='.(int) min(Shop::getContextListShopID());
        $this->_where .= ' AND wkpscatlg.`id_shop`='.(int) min(Shop::getContextListShopID());
        // dump($this->_join);die;
        $this->fields_list = array(
            'id_wk_blog_post' => array(
                'title' => $this->l('ID'),
                'align' => 'center',
                'class' => 'fixed-width-xs',
                'havingFilter' => true
            ),
            'cat_name' => array(
                'title' => $this->l('Category'),
                'align' => 'center',
                'havingFilter' => true
            ),
            'title' => array(
                'title' => $this->l('Title'),
                'align' => 'center',
                'maxlength' => 100,
                'havingFilter' => true
            ),
            'descr' => array(
                'title' => $this->l('Description'),
                'align' => 'center',
                'callback' => 'getDescriptionClean',
                'maxlength' => 100,
                'havingFilter' => true
            ),
            'link_rewrite' => array(
                'title' => $this->l('Preview'),
                'align' => 'center',
                'callback' => 'previewBlog',
                'class' => 'fixed-width-xs',
                'remove_onclick' => true,
                'search' => false
            ),
            'active' => array(
                'title' => $this->l('Status'),
                'align' => 'center',
                'active' => 'status',
                'type' => 'bool',
                'class' => 'fixed-width-xs',
            ),
        );
        $this->bulk_actions = array(
            'delete' => array('text' => $this->l('Delete selected'),
                'icon' => 'icon-trash',
                'confirm' => $this->l('Delete selected items?'),
            ),
        );
    }

    public function initContent()
    {
        if (($this->display == 'edit') && (Shop::getContext() == Shop::CONTEXT_SHOP)) {
            $objpost= $this->loadObject(true);
            // dump($objpost);die;
            if (!$objpost->id_category) {
                Tools::redirectAdmin(self::$currentIndex.'&token='.$this->token);
            }
        }
        return parent::initContent();
    }

    public function previewBlog($val, $arr)
    {
        $params = array(
            'post' => $arr['link_rewrite'],
        );
        if (isset($val)) {
            $blog_link = $this->context->link->getModuleLink('wkblogpost', 'readmore', $params);
            $html = $this->context->smarty->fetch(
                _PS_MODULE_DIR_.'wkblogpost/views/templates/admin/_partials/previewbloglink.tpl',
                array('wkBlogLink' => $blog_link)
            );
        }
        return $html;
    }

    public function renderList()
    {
        $this->addRowAction('edit');
        $this->addRowAction('delete');

        return parent::renderList();
    }

    public static function getDescriptionClean($description)
    {
        return Tools::getDescriptionClean($description);
    }

    public function initToolbar()
    {
        parent::initToolbar();

        $this->page_header_toolbar_btn['new'] = array(
            'href' => self::$currentIndex.'&add'.$this->table.'&token='.$this->token,
            'desc' => $this->l('Create New Blog'),
        );
    }

    public function renderForm()
    {
        if (($this->display == 'edit') && (Shop::getContext() != Shop::CONTEXT_SHOP)) {
            return $this->context->smarty->fetch(
                _PS_MODULE_DIR_.$this->module->name.'/views/templates/admin/_partials/shop_warning.tpl'
            );
        } else {
            $id_lang = $this->context->language->id;
            $obj_wkcategory = new WkBlogPostCategory();
            $all_cat = $obj_wkcategory->getAllCategories($id_lang);
            if ($this->display == 'add') {
                $this->context->smarty->assign('current_date', date('Y-m-d H:s:m'));
            } elseif ($this->display == 'edit') {
                $id = Tools::getValue('id_wk_blog_post');
                $featuredImage = $this->absolutePath.'/'.$id.'/'.$id.'_blog.jpg';
                $thumbnailImage = $this->absolutePath.'/'.$id.'/'.$id.'_blog_thumbnail.jpg';
                if (file_exists($featuredImage)) {
                    $this->context->smarty->assign('featuredImage', 1);
                }
                if (file_exists($thumbnailImage)) {
                    $this->context->smarty->assign('thumbnailImage', 1);
                }
                $obj_wkpost = new WkBlogPostData($id);
                if (!empty($obj_wkpost)) {
                    $this->context->smarty->assign(
                        array(
                            'obj_wkpost' => $obj_wkpost,
                            'id_blog' => Tools::getValue('id_wk_blog_post'),
                        )
                    );
                }
            }
            $id_lang = $this->context->language->id;
            $this->context->smarty->assign(
                array(
                    'id_lang' => $id_lang,
                    'all_cat' => $all_cat,
                    'time' => time(),
                    'total_languages' => count(Language::getLanguages()),
                    'ps_allow_accented_chars_url' => Configuration::get('PS_ALLOW_ACCENTED_CHARS_URL'),
                )
            );
            $this->fields_form = array(
                'submit' => array(
                    'title' => $this->l('Save'),
                ),
            );

            return parent::renderForm();
        }
    }

    public function processSave()
    {
        $this->validateBlog();
        $id_blog = Tools::getValue('id_wk_blog_post');
        if (empty($this->errors)) {
            $obj_wkimg = new WkBlogPostImage();
            $default_lang = Configuration::get('PS_LANG_DEFAULT');
            $id_cat = Tools::getValue('wkblog_cat');
            $date_publish = Tools::getValue('wkpublish_date');
            $status = Tools::getValue('wkblog_status');
            $feature_img = $_FILES['wkpost_featured']['name'];
            $thumbnail_img = $_FILES['wkpost_thumbnail']['name'];
            if ($id_blog) {
                $obj_wkblog = new WkBlogPostData($id_blog);
            } else {
                $obj_wkblog = new WkBlogPostData();
            }
            $obj_wkblog->id_category = $id_cat;
            $obj_wkblog->date_add = $date_publish;
            $obj_wkblog->active = $status;
            $obj_wkblog->id_author = $this->context->employee->id;
            foreach (Language::getLanguages(true) as $language) {
                $wkblog_title_lang_id = $language['id_lang'];
                $link_rewrite_lang_id = $language['id_lang'];
                $wkblog_desc_lang_id = $language['id_lang'];
                $wkblog_meta_title_lang_id = $language['id_lang'];
                $wkblog_meta_desc_lang_id = $language['id_lang'];
                $wkblog_meta_keyword_lang_id = $language['id_lang'];

                if (!trim(Tools::getValue('wkblog_title_'.$language['id_lang']))) {
                    $wkblog_title_lang_id = $default_lang;
                }
                if (!trim(Tools::getValue('link_rewrite_'.$language['id_lang']))) {
                    $link_rewrite_lang_id = $default_lang;
                }
                if (!trim(Tools::getValue('wkblog_desc_'.$language['id_lang']))) {
                    $wkblog_desc_lang_id = $default_lang;
                }
                if (!trim(Tools::getValue('wkblog_meta_title_'.$language['id_lang']))) {
                    $wkblog_meta_title_lang_id = $default_lang;
                }
                if (!trim(Tools::getValue('wkblog_meta_desc_'.$language['id_lang']))) {
                    $wkblog_meta_desc_lang_id = $default_lang;
                }
                if (!trim(Tools::getValue('wkblog_meta_keyword_'.$language['id_lang']))) {
                    $wkblog_meta_keyword_lang_id = $default_lang;
                }

                $obj_wkblog->title[$language['id_lang']] = Tools::getValue('wkblog_title_'.$wkblog_title_lang_id);

                // remove last underscore from link rewrite string
                $link_rewrite = Tools::getValue('link_rewrite_'.$link_rewrite_lang_id);
                $link_rewrite = preg_replace('/-[-^]*$/', '', $link_rewrite);

                $obj_wkblog->link_rewrite[$language['id_lang']] = $link_rewrite;
                $obj_wkblog->description[$language['id_lang']] = Tools::getValue('wkblog_desc_'.$wkblog_desc_lang_id);
                $obj_wkblog->meta_title[$language['id_lang']] =
                Tools::getValue('wkblog_meta_title_'.$wkblog_meta_title_lang_id);
                $obj_wkblog->meta_keyword[$language['id_lang']] =
                Tools::getValue('wkblog_meta_keyword_'.$wkblog_meta_keyword_lang_id);
                $obj_wkblog->meta_description[$language['id_lang']] =
                Tools::getValue('wkblog_meta_desc_'.$wkblog_meta_desc_lang_id);
            }
            if ($obj_wkblog->save()) {
                if (!empty($feature_img)) {
                    $obj_wkimg->uploadFeatureImage($obj_wkblog->id, 'blog');
                }
                if (!empty($thumbnail_img)) {
                    $obj_wkimg->uploadFeatureImage($obj_wkblog->id, 'blog_thumbnail');
                }
            }
            if (Tools::isSubmit('submitAdd'.$this->table.'AndStay')) {
                if ($id_blog) {
                    Tools::redirectAdmin(
                        self::$currentIndex.'&id_wk_blog_post='.(int) $id_blog.
                        '&update'.$this->table.'&conf=4&token='.$this->token
                    );
                } else {
                    Tools::redirectAdmin(
                        self::$currentIndex.'&id_wk_blog_post='.(int) $obj_wkblog->id.
                        '&update'.$this->table.'&conf=3&token='.$this->token
                    );
                }
            } else {
                if ($id_blog) {
                    Tools::redirectAdmin(self::$currentIndex.'&conf=4&token='.$this->token);
                } else {
                    Tools::redirectAdmin(self::$currentIndex.'&conf=3&token='.$this->token);
                }
            }
        } else {
            if ($id_blog) {
                $this->display = 'edit';
            } else {
                $this->display = 'add';
            }
        }
    }

    public function validateBlog()
    {
        $obj_wkimg = new WkBlogPostImage();
        $default_lang = Configuration::get('PS_LANG_DEFAULT');
        $id_cat = Tools::getValue('wkblog_cat');
        $feature_img = $_FILES['wkpost_featured']['name'];
        $thumbnail_img = $_FILES['wkpost_thumbnail']['name'];
        if (!$id_cat) {
            $this->errors[] = $this->l('Category is missing.');
        }
        if (!trim(Tools::getValue('wkblog_title_'.$default_lang))) {
            $this->errors[] = $this->l('Title cannot be empty for default language.');
        }
        if (!trim(Tools::getValue('link_rewrite_'.$default_lang))) {
            $this->errors[] = $this->l('Friendly URL cannot be empty for default language.');
        }
        $cleanHtmlContent = Tools::getDescriptionClean(Tools::getValue('wkblog_desc_'.$default_lang));
        $cleanHtmlContent = str_replace(chr(0xC2).chr(0xA0), "", $cleanHtmlContent);
        $cleanHtmlContent = str_replace('&nbsp;', "", $cleanHtmlContent);
        if (!trim($cleanHtmlContent)) {
            $this->errors[] = $this->l('Description cannot be empty for default language.');
        } elseif (!Validate::isCleanHtml(Tools::getDescriptionClean(Tools::getValue('wkblog_desc_'.$default_lang)))
            || $this->checkScriptInHtml($cleanHtmlContent)
        ) {
            $this->errors[] = $this->l('The blog description is invalid.');
        }
        foreach (Language::getLanguages(false) as $language) {
            $localizedTitle = Tools::getValue('wkblog_title_'.$language['id_lang']);
            if (!Validate::isCatalogName($localizedTitle) && trim($localizedTitle)) {
                $this->errors['wkblog_title_'.$language['id_lang']] = sprintf(
                    $this->l('The title is invalid in language %s.'),
                    $language['name']
                );
            } elseif (Tools::strlen($localizedTitle) > 255) {
                $this->errors['wkblog_title_'.$language['id_lang']] = sprintf(
                    $this->l('Title is larger than 255 characters in %s.'),
                    $language['name']
                );
            }
            if (!Validate::isLinkRewrite(Tools::getValue('link_rewrite_'.$language['id_lang']))
                && trim(Tools::getValue('link_rewrite_'.$language['id_lang']))) {
                $this->errors['link_rewrite_'.$language['id_lang']] = sprintf(
                    $this->l('The Friendly url is invalid in %s language.'),
                    $language['name']
                );
            }
            $cleanHtmlContent = Tools::getDescriptionClean(Tools::getValue('wkblog_desc_'.$language['id_lang']));
            $cleanHtmlContent = str_replace(chr(0xC2).chr(0xA0), "", $cleanHtmlContent);
            if ((!Validate::isCleanHtml(Tools::getValue('wkblog_desc_'.$language['id_lang']))
                || $this->checkScriptInHtml($cleanHtmlContent))
                && trim($cleanHtmlContent)
            ) {
                $this->errors['wkblog_desc_'.$language['id_lang']] =
                $this->l('The blog description is invalid.');
            }
            if (trim(Tools::getValue('wkblog_meta_title_'.$default_lang))
                && !Validate::isCatalogName(Tools::getValue('wkblog_meta_title_'.$default_lang))
            ) {
                $this->errors[] = $this->l('Meta Title is not valid.');
            }
            if (trim(Tools::getValue('wkblog_meta_desc_'.$default_lang))
                && !Validate::isCleanHtml(Tools::getValue('wkblog_meta_desc_'.$default_lang))
            ) {
                $this->errors[] = $this->l('Meta Description is not valid.');
            }
            if (trim(Tools::getValue('wkblog_meta_keyword_'.$default_lang))
                && !Validate::isCatalogName(Tools::getValue('wkblog_meta_keyword_'.$default_lang))
            ) {
                $this->errors[] = $this->l('Meta Keywords is not valid.');
            }
        }
        if (!empty($feature_img)) {
            if (!$obj_wkimg->validateImageExt($_FILES['wkpost_featured'])) {
                $this->errors[] = $this->l('Image format not recognized, allowed formats are: .gif, .jpg, .png');
            }
        }
        if (!empty($thumbnail_img)) {
            if (!$obj_wkimg->validateImageExt($_FILES['wkpost_thumbnail'])) {
                $this->errors[] = $this->l('Image format not recognized, allowed formats are: .gif, .jpg, .png');
            }
        }
    }

    public function checkScriptInHtml($html)
    {
        if (trim($html)) {
            $dom = new DOMDocument();
            $dom->loadHTML(htmlspecialchars_decode($html));
            $script = $dom->getElementsByTagName('script');
            return $script->length;
        } else {
            return 0;
        }
    }

    public function postProcess()
    {
        if (!$this->loadObject(true)) {
            return;
        }
        $id_image = Tools::getValue('id_delete');
        $wk_blog = Tools::getValue('wk_blog');
        $wk_blog_thumbnail = Tools::getValue('wk_blog_thumbnail');
        if ($id_image) {
            if ($wk_blog) {
                $path = $this->absolutePath.'/'.$id_image.'/'.$id_image.'_blog.jpg';
            } elseif ($wk_blog_thumbnail) {
                $path = $this->absolutePath.'/'.$id_image.'/'.$id_image.'_blog_thumbnail.jpg';
            } else {
                return false;
            }

            if (file_exists($path)) {
                unlink($path);
                Tools::redirectAdmin(
                    self::$currentIndex.'&id_wk_blog_post='.(int) $id_image.'&update'.$this->table.'&conf=7&token='
                    .$this->token
                );
            } else {
                Tools::redirectAdmin(
                    self::$currentIndex.'&token='.Tools::getAdminTokenLite('AdminWkBlogPost').'&conf=1'
                );
            }
        }
        parent::postProcess();
    }

    public function setMedia($isNewTheme = false)
    {
        parent::setMedia($isNewTheme);
        $this->addJS(_PS_JS_DIR_.'tiny_mce/tiny_mce.js');
        if (version_compare(_PS_VERSION_, '1.6.0.11', '>')) {
            $this->addJS(_PS_JS_DIR_.'admin/tinymce.inc.js');
        } else {
            $this->addJS(_PS_JS_DIR_.'tinymce.inc.js');
        }
        $this->addCSS(_MODULE_DIR_.'wkblogpost/views/css/wkadminblogpost.css');
        $this->addJS(_MODULE_DIR_.'wkblogpost/views/js/admin/wkblogpost.js');
    }
}
