<?php
/**
* 2010-2021 Webkul.
*
* NOTICE OF LICENSE
*
* All right is reserved,
* Please go through LICENSE.txt file inside our module
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade this module to newer
* versions in the future. If you wish to customize this module for your
* needs please refer to CustomizationPolicy.txt file inside our module for more information.
*
* @author Webkul IN
* @copyright 2010-2021 Webkul IN
* @license LICENSE.txt
*/

class AdminWkCategoryPostController extends ModuleAdminController
{
    public function __construct()
    {
        $this->identifier = 'id_wk_blogpost_category';
        parent::__construct();
        $context = Context::getContext();
        $this->table = 'wk_blogpost_category';
        $this->className = 'WkBlogPostCategory';
        $this->bootstrap = true;
        if (Shop::getContext() == Shop::CONTEXT_SHOP) {
            Shop::addTableAssociation(
                'wk_blogpost_category',
                array('type' => 'shop', 'primary' => 'id_wk_blogpost_category')
            );
        }
        $this->_join .= Shop::addSqlAssociation('wk_blogpost_category', 'a', false);
        $this->_group = ' GROUP BY a.id_wk_blogpost_category';
        $this->_join .= 'LEFT JOIN `'._DB_PREFIX_.'wk_blogpost_category_lang` wkpscatlg
        ON (wkpscatlg.`id_wk_blogpost_category` = a.`id_wk_blogpost_category`)';
        $this->_select = 'wkpscatlg.`title` as `name`, wkpscatlg.`description` as `descr`';
        if (Shop::getContext() == Shop::CONTEXT_SHOP) {
            $this->_select .= ', wk_blogpost_category_shop.`active`';
        }
        $this->_where = 'AND wkpscatlg.`id_lang` = '.(int) $context->language->id;
        $this->_where .= ' AND wkpscatlg.`id_shop`='.(int) min(Shop::getContextListShopID());
        $this->absolutePath = _PS_MODULE_DIR_.'wkblogpost/views/img/category/';
        $this->deleted = false;
        $this->fields_list = array(
            'id_wk_blogpost_category' => array(
                'title' => $this->l('Id'),
                'class' => 'fixed-width-xs',
                'align' => 'center',
                'havingFilter' => true
                ),
            'name' => array(
                'title' => $this->l('Name'),
                'align' => 'center',
                'havingFilter' => true,
                ),
            'descr' => array(
                'title' => $this->l('Description'),
                'align' => 'center',
                'callback' => 'getDescriptionClean',
                'havingFilter' => true
                ),
            'active' => array(
                'title' => $this->l('Status'),
                'active' => 'status',
                'align' => 'center',
                'type' => 'bool'
                ),
        );
        $this->bulk_actions = array(
            'delete' => array('text' => $this->l('Delete selected'),
                'icon' => 'icon-trash',
                'confirm' => $this->l('Delete selected items?'),
            ),
        );
    }

    public function initContent()
    {

        if (($this->display == 'edit') && (Shop::getContext() == Shop::CONTEXT_SHOP)) {
            $objCat= $this->loadObject(true);
        //     dump($this->loadObject(true));
        // die;
            if (!$objCat->id_wk_blogpost_category) {
                Tools::redirectAdmin(self::$currentIndex.'&token='.$this->token);
            }
        }
        return parent::initContent();
    }

    /**
     * Remove all html tags from the description.
     *
     * @param string $description description content
     * @return string description
     */
    public static function getDescriptionClean($description)
    {
        return Tools::getDescriptionClean($description);
    }

    public function initToolbar()
    {
        $this->page_header_toolbar_btn['new'] = array(
            'href' => self::$currentIndex.'&add'.$this->table.'&token='.$this->token,
            'desc' => $this->l('Create New Category'),
            );
        parent::initToolbar();
    }

    public function renderList()
    {
        $default = WkBlogPostCategory::getDefaultCategory();
        $blogPostObj = new WkBlogPostData();

        $this->addRowAction('edit');
        $this->addRowAction('delete');
        $this->addRowActionSkipList('delete', $default['id_wk_blogpost_category']);
        $catIds = $blogPostObj->getCatIds();
        if (!empty($catIds)) {
            foreach ($catIds as $catid) {
                $this->addRowActionSkipList('delete', $catid['id_category']);
            }
        }
        $this->addRowActionSkipList('Default', $default['id_wk_blogpost_category']);
        $this->addRowAction('Default');
        if (Tools::isSubmit('delete'.$this->table)) {
            $wk_cat = new WkBlogPostCategory((int) Tools::getValue('id_wk_blogpost_category'));
            if ($wk_cat->is_default) {
                $this->tpl_list_vars['need_delete_mode'] = false;
            } else {
                $this->tpl_list_vars['need_delete_mode'] = true;
            }
            $this->tpl_list_vars['delete_category'] = true;
            $this->tpl_list_vars['REQUEST_URI'] = $_SERVER['REQUEST_URI'];
            $this->tpl_list_vars['POST'] = $_POST;
            $this->tpl_list_vars['is_delete'] = true;
        } elseif (Tools::isSubmit('submitBulkdelete'.$this->table)) {
            $this->tpl_list_vars['need_delete_mode'] = true;
            $this->tpl_list_vars['delete_category'] = true;
            $this->tpl_list_vars['REQUEST_URI'] = $_SERVER['REQUEST_URI'];
            $this->tpl_list_vars['_POST'] = $_POST;
            $this->tpl_list_vars['wk_blogpost_categoryBox'] = Tools::getValue('wk_blogpost_categoryBox');
            $this->tpl_list_vars['is_delete'] = true;
        }

        return parent::renderList();
    }

    public function checkScriptInHtml($html)
    {
        if (trim($html)) {
            $dom = new DOMDocument();
            $dom->loadHTML(htmlspecialchars_decode($html));
            $script = $dom->getElementsByTagName('script');
            return $script->length;
        } else {
            return 0;
        }
    }

    public function renderForm()
    {
        if (($this->display == 'edit') && (Shop::getContext() != Shop::CONTEXT_SHOP)) {
            return $this->context->smarty->fetch(
                _PS_MODULE_DIR_.$this->module->name.'/views/templates/admin/_partials/shop_warning.tpl'
            );
        } else {
            //tinymce setup
            $this->context->smarty->assign('path_css', _THEME_CSS_DIR_);
            $this->context->smarty->assign('ad', __PS_BASE_URI__.basename(_PS_ADMIN_DIR_));
            $this->context->smarty->assign('autoload_rte', true);
            $this->context->smarty->assign('lang', true);
            $this->context->smarty->assign('iso', $this->context->language->iso_code);
            $id_lang = $this->context->language->id;
            if ($this->display == 'add') {
            } elseif ($this->display == 'edit') {
                $id = Tools::getValue('id_wk_blogpost_category');
                $image = $this->absolutePath.$id.'_cat.jpg';
                if (file_exists($image)) {
                    $this->context->smarty->assign('image_exist', 1);
                }
                $obj_wkcat = new WkBlogPostCategory($id);
                if (!empty($obj_wkcat)) {
                    $this->context->smarty->assign(array(
                        'obj_wkcat' => $obj_wkcat,
                        'id_cat' => Tools::getValue('id_wk_blogpost_category'),
                    ));
                }
            }

            $this->context->smarty->assign(
                array(
                    'id_lang' => $id_lang,
                    'languages' => Language::getLanguages(),
                    'total_languages' => count(Language::getLanguages()),
                    'modules_dir' => _MODULE_DIR_,
                    'ps_allow_accented_chars_url' => (int) Configuration::get('PS_ALLOW_ACCENTED_CHARS_URL'),
                )
            );
            $this->fields_form = array(
                    'submit' => array(
                        'title' => $this->l('Save'),
                    ),
                );

            return parent::renderForm();
        }
    }

    public function processSave()
    {
        $obj_wkimg = new WkBlogPostImage();
        $default_lang = Configuration::get('PS_LANG_DEFAULT');
        $id_cat = Tools::getValue('id_wk_blogpost_category');
        $feature_img = $_FILES['wkcat_featured']['name'];

        if (!trim(Tools::getValue('wkcat_title_'.$default_lang))) {
            $this->errors[] = $this->l('Title can not be empty for default language.');
        }
        if (!trim(Tools::getValue('link_rewrite_'.$default_lang))) {
            $this->errors[] = $this->l('Friendly URL can not be empty for default language.');
        }

        foreach (Language::getLanguages(false) as $language) {
            if (!Validate::isCatalogName(Tools::getValue('wkcat_title_'.$language['id_lang']))
                && trim(Tools::getValue('wkcat_title_'.$language['id_lang']))
            ) {
                $this->errors['wkcat_title_'.$language['id_lang']] = sprintf(
                    $this->l('The category title is invalid in "%s" language.'),
                    $language['name']
                );
            }
            if (!Validate::isLinkRewrite(Tools::getValue('link_rewrite_'.$language['id_lang']))
                && trim(Tools::getValue('link_rewrite_'.$language['id_lang']))
            ) {
                $this->errors['link_rewrite_'.$language['id_lang']] = sprintf(
                    $this->l('The friendly url is invalid in "%s" language.'),
                    $language['name']
                );
            }

            $cleanHtmlContent = Tools::getDescriptionClean(Tools::getValue('wkcat_desc_'.$language['id_lang']));
            $cleanHtmlContent = str_replace(chr(0xC2).chr(0xA0), "", $cleanHtmlContent);
            $cleanHtmlContent = str_replace('&nbsp;', "", $cleanHtmlContent);
            if (trim($cleanHtmlContent)
                && (!Validate::isCleanHtml(Tools::getValue('wkcat_desc_'.$language['id_lang']))
                || $this->checkScriptInHtml(Tools::getValue('wkcat_desc_'.$language['id_lang'])))
            ) {
                $this->errors[] = sprintf(
                    $this->l('Please enter valid description in %s language.'),
                    $language['name']
                );
            }

            if (trim(Tools::getValue('wkcat_meta_title_'.$default_lang))
                && !Validate::isCatalogName(Tools::getValue('wkcat_meta_title_'.$default_lang))
            ) {
                $this->errors[] = $this->l('Meta Title is not valid.');
            }
            if (trim(Tools::getValue('wkcat_meta_desc_'.$default_lang))
                && !Validate::isCleanHtml(Tools::getValue('wkcat_meta_desc_'.$default_lang))
            ) {
                $this->errors[] = $this->l('Meta Description is not valid.');
            }
            if (trim(Tools::getValue('wkcat_meta_keyword_'.$default_lang))
                && !Validate::isCatalogName(Tools::getValue('wkcat_meta_keyword_'.$default_lang))
            ) {
                $this->errors[] = $this->l('Meta keyword is not valid.');
            }
        }

        //check image extention valid or not
        if (!empty($feature_img)) {
            if (!$obj_wkimg->validateImageExt($_FILES['wkcat_featured'])) {
                $this->errors[] = $this->l('Image format not recognized, allowed formats are: .gif, .jpg, .png');
            }
        }

        if (empty($this->errors)) {
            if ($id_cat) {
                $obj_wkcat = new WkBlogPostCategory($id_cat);
            } else {
                $obj_wkcat = new WkBlogPostCategory();
            }

            $obj_wkcat->active = Tools::getValue('wkblog_status');

            // category lang
            foreach (Language::getLanguages(true) as $language) {
                $wkcat_title_lang_id = $language['id_lang'];
                $link_rewrite_lang_id = $language['id_lang'];
                $wkcat_desc_lang_id = $language['id_lang'];
                $wkcat_meta_title_lang_id = $language['id_lang'];
                $wkcat_meta_desc_lang_id = $language['id_lang'];
                $wkcat_meta_keyword_lang_id = $language['id_lang'];

                if (!trim(Tools::getValue('wkcat_title_'.$language['id_lang']))) {
                    $wkcat_title_lang_id = $default_lang;
                }
                if (!trim(Tools::getValue('link_rewrite_'.$language['id_lang']))) {
                    $link_rewrite_lang_id = $default_lang;
                }
                if (!trim(Tools::getValue('wkcat_desc_'.$language['id_lang']))) {
                    $wkcat_desc_lang_id = $default_lang;
                }
                if (!trim(Tools::getValue('wkcat_meta_title_'.$language['id_lang']))) {
                    $wkcat_meta_title_lang_id = $default_lang;
                }
                if (!trim(Tools::getValue('wkcat_meta_desc_'.$language['id_lang']))) {
                    $wkcat_meta_desc_lang_id = $default_lang;
                }
                if (!trim(Tools::getValue('wkcat_meta_keyword_'.$language['id_lang']))) {
                    $wkcat_meta_keyword_lang_id = $default_lang;
                }

                $obj_wkcat->title[$language['id_lang']] = Tools::getValue('wkcat_title_'.$wkcat_title_lang_id);

                // remove last underscore from link rewrite string
                $link_rewrite = Tools::getValue('link_rewrite_'.$link_rewrite_lang_id);
                $link_rewrite = preg_replace('/-[-^]*$/', '', $link_rewrite);

                $obj_wkcat->link_rewrite[$language['id_lang']] = $link_rewrite;
                $obj_wkcat->description[$language['id_lang']] = Tools::getValue('wkcat_desc_'.$wkcat_desc_lang_id);
                $obj_wkcat->meta_title[$language['id_lang']] =
                Tools::getValue('wkcat_meta_title_'.$wkcat_meta_title_lang_id);
                $obj_wkcat->meta_keyword[$language['id_lang']] =
                Tools::getValue('wkcat_meta_keyword_'.$wkcat_meta_desc_lang_id);
                $obj_wkcat->meta_description[$language['id_lang']] =
                Tools::getValue('wkcat_meta_desc_'.$wkcat_meta_keyword_lang_id);
            }
            if ($obj_wkcat->save()) {
                if (!empty($feature_img)) {
                    $obj_wkimg->uploadFeatureImage($obj_wkcat->id, 'cat');
                }
                if (Tools::isSubmit('submitAdd'.$this->table.'AndStay')) {
                    if ($id_cat) {
                        Tools::redirectAdmin(
                            self::$currentIndex.'&id='.(int) $id_cat.
                            '&update'.$this->table.'&conf=4&token='.$this->token
                        );
                    } else {
                        Tools::redirectAdmin(
                            self::$currentIndex.'&id='.(int) $obj_wkcat->id.
                            '&update'.$this->table.'&conf=3&token='.$this->token
                        );
                    }
                } else {
                    Tools::redirectAdmin(self::$currentIndex.'&conf=3&token='.$this->token);
                }
            } else {
                // dump($obj_wkcat->error());die;
            }
        } else {
            if ($id_cat) {
                $this->display = 'edit';
            } else {
                $this->display = 'add';
            }
        }
    }

    public function postProcess()
    {
        if (!$this->loadObject(true)) {
            return;
        }

        // delete featured image
        $id_image = Tools::getValue('id_delete');
        if ($id_image) {
            $path = $this->absolutePath.$id_image.'_cat.jpg';
            if (file_exists($path)) {
                unlink($path);
                Tools::redirectAdmin(
                    self::$currentIndex.'&id_wk_blogpost_category='.(int) $id_image.'&update'.$this->table
                    .'&conf=7&token='.$this->token
                );
            } else {
                Tools::redirectAdmin(
                    self::$currentIndex.'&token='.Tools::getAdminTokenLite('AdminWkCategoryPost').'&conf=1'
                );
            }
        }

        // make category as default
        if (Tools::isSubmit('default'.$this->table)) {
            $id = Tools::getValue('id_wk_blogpost_category');
            if ($id) {
                $obj_wkcat = new WkBlogPostCategory($id);
                if (!$obj_wkcat->active) {
                    $this->errors[] = $this->l('Category must be active to make default.');
                }
                if (empty($this->errors)) {
                    $default = WkBlogPostCategory::getDefaultCategory();
                    if ($default) {
                        WkBlogPostCategory::removeDefaultCategory($default['id_wk_blogpost_category']);
                    }
                    $obj_wkcat->is_default = 1;
                    $obj_wkcat->save();
                }
            }
        }
        parent::postProcess();
    }

    public function setMedia($isNewTheme = false)
    {
        parent::setMedia($isNewTheme);
        $this->addJS(_PS_JS_DIR_.'tiny_mce/tiny_mce.js');
        if (version_compare(_PS_VERSION_, '1.6.0.11', '>')) {
            $this->addJS(_PS_JS_DIR_.'admin/tinymce.inc.js');
        } else {
            $this->addJS(_PS_JS_DIR_.'tinymce.inc.js');
        }
        $this->addCSS(_MODULE_DIR_.'wkblogpost/views/css/wkblogcat.css');
    }
}
