<?php
/**
* 2010-2021 Webkul.
*
* NOTICE OF LICENSE
*
* All right is reserved,
* Please go through LICENSE.txt file inside our module
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade this module to newer
* versions in the future. If you wish to customize this module for your
* needs please refer to CustomizationPolicy.txt file inside our module for more information.
*
* @author Webkul IN
* @copyright 2010-2021 Webkul IN
* @license LICENSE.txt
*/

class WkBlogPostCategoryPostModuleFrontController extends ModuleFrontController
{
    public function initContent()
    {
        parent::initContent();
        $this->display_column_left = false;
        $this->display_column_right = false;
        $id_lang = $this->context->language->id;
        $obj_wkcat = new WkBlogPostCategory();
        $obj_wkpost = new WkBlogPostData();
        $active_cats = $obj_wkcat->activeCategories($id_lang);
        $category = trim(Tools::getValue('cat'));
        $category_content = $obj_wkcat->activeCategoriesByCategoryName($category, $id_lang);
        // pagination
        $page_no = Tools::getValue('page');
        if (!$page_no) {
            $page_no = 1;
        }
        $no_post = Configuration::get('WK_NO_OF_BLOG_POST');

        if ($page_no > 1) {
            $start = ($page_no * $no_post) - $no_post;
            $limit = $start.','.$no_post;
        } else {
            $limit = ($page_no == 1 ? 0 : $page_no).','.$no_post;
        }

        if ($category_content) {
            $all_category_posts = $obj_wkpost->getActivePostByCategoryId(
                $category_content['id_wk_blogpost_category'],
                $id_lang
            );
            $post = $obj_wkpost->getActivePostByCategoryIdWithLimit(
                $category_content['id_wk_blogpost_category'],
                $id_lang,
                $limit
            );
            if ($all_category_posts) {
                // pagination
                if ((count($all_category_posts) / $no_post) > $page_no) {
                    $this->context->smarty->assign('pagination', 1);
                }
            }
            if (!empty($post)) {
                $this->context->smarty->assign(
                    array(
                        'listing_posts' => $post
                    )
                );
            }
            $this->context->smarty->assign(
                array(
                    'no_content' => 1,
                    'category_content' => $category_content,
                    'meta_title' => $category_content['meta_title'],
                    'meta_desc' => $category_content['meta_description'],
                    'meta_keys' => $category_content['meta_keyword']
                )
            );
        }
        if (!is_array($active_cats)) {
            $active_cats = array();
        }
        $this->context->smarty->assign(
            array(
                'ps_module_dir' => _MODULE_DIR_,
                'no_cat' => Configuration::get('WK_NO_OF_BLOG_CATEGORY'),
                'all_category' => array_values($active_cats),
                'category' => $category,
                'module_path' => _PS_MODULE_DIR_,
                'next_page' => $page_no + 1,
                'previous_page' => $page_no - 1,
                'category_on' => Configuration::get('WK_BLOG_CATEGORY_ON'),
                'controller' => Tools::getValue('controller'),
                'wk_rewrite_enabled' => Configuration::get('PS_REWRITING_SETTINGS'),
            )
        );
        $this->setTemplate('module:wkblogpost/views/templates/front/blogpost_list.tpl');
    }

    public function getBreadcrumbLinks()
    {
        $breadcrumb = parent::getBreadcrumbLinks();
        $breadcrumb['links'][] = array(
            'title' => $this->module->l('Category', 'wkblogpost'),
            'url' => 'javascript:void(0)',
        );

        return $breadcrumb;
    }

    public function setMedia()
    {
        parent::setMedia();
        $this->registerStylesheet(
            'bloglist',
            'modules/'.$this->module->name.'/views/css/wkbloglist.css'
        );
    }
}
