<?php
/**
* 2010-2021 Webkul.
*
* NOTICE OF LICENSE
*
* All right is reserved,
* Please go through LICENSE.txt file inside our module
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade this module to newer
* versions in the future. If you wish to customize this module for your
* needs please refer to CustomizationPolicy.txt file inside our module for more information.
*
* @author Webkul IN
* @copyright 2010-2021 Webkul IN
* @license LICENSE.txt
*/

class WkBlogPostReadMoreModuleFrontController extends ModuleFrontController
{

    public function initContent()
    {
        parent::initContent();
        $id_lang = $this->context->language->id;
        $obj_wkpost = new WkBlogPostData();
        $obj_wkcat = new WkBlogPostCategory();
        $active_cats = $obj_wkcat->activeCategories($id_lang);
        if (empty($active_cats)) {
            $active_cats = array();
        }
        $post = trim(Tools::getValue('post'));
        $wkblog_id = Tools::getValue('wkblog_id');
        if ($wkblog_id) {
            $post_content = $obj_wkpost->getBlogWithId($wkblog_id, $id_lang);
        } else {
            $post_content = $obj_wkpost->getPostByString($post, $id_lang, true);
        }
        if ($post_content) {
            $post_content['blog_url'] = $this->context->link->getModuleLink(
                'wkblogpost',
                'readmore',
                array(
                    'post' => $post_content['link_rewrite']
                )
            );
            if ($post_content['meta_title']) {
                $this->context->smarty->assign('meta_title', $post_content['meta_title']);
            }
            if ($post_content['meta_keyword']) {
                $this->context->smarty->assign('meta_keywords', $post_content['meta_keyword']);
            }
            if ($post_content['meta_description']) {
                $this->context->smarty->assign('meta_description', $post_content['meta_description']);
            }
            $category = new WkBlogPostCategory($post_content['id_category'], $id_lang);
            if (Validate::isLoadedObject($category)) {
                $this->context->smarty->assign('category', $category);
            }
        }
        // dump($post_content);die;
        $this->context->smarty->assign(
            array(
                'post_content' => $post_content,
                'time' => time(),
                'ps_module_dir' => _MODULE_DIR_,
                'all_category' => array_values($active_cats),
                'no_cat' => Configuration::get('WK_NO_OF_BLOG_CATEGORY'),
                'category_on' => Configuration::get('WK_BLOG_CATEGORY_ON'),
                'module_path' => _PS_MODULE_DIR_,
                'controller' => Tools::getValue('controller'),
                'wk_rewrite_enabled' => Configuration::get('PS_REWRITING_SETTINGS')
            )
        );
        $this->setTemplate('module:wkblogpost/views/templates/front/readmore.tpl');
    }

    public function getBreadcrumbLinks()
    {
        $obj_wkpost = new WkBlogPostData();
        $id_lang = $this->context->language->id;
        $post = trim(Tools::getValue('post'));
        $wkblog_id = Tools::getValue('wkblog_id');
        if ($wkblog_id) {
            $post_content = $obj_wkpost->getBlogWithId($post, $id_lang);
        } else {
            $post_content = $obj_wkpost->getPostByString($post, $id_lang, true);
        }

        $breadcrumb = parent::getBreadcrumbLinks();
        $breadcrumb['links'][] = array(
            'title' => $this->module->l('Blog', 'wkblogpost'),
            'url' => $this->context->link->getModuleLink($this->module->name, 'blogpost'),
        );

        if ($post_content) {
            if (Tools::strlen($post_content['title']) > 30) {
                $title = Tools::substr($post_content['title'], 0, 30).'...';
            } else {
                $title = $post_content['title'];
            }
            $breadcrumb['links'][] = array(
                'title' => $this->module->l($title, 'wkblogpost'),
                'url' => '',
            );
        }


        return $breadcrumb;
    }

    public function setMedia()
    {
        parent::setMedia();
        $this->registerStylesheet(
            'bloglist',
            'modules/'.$this->module->name.'/views/css/wkbloglist.css'
        );
    }
}
