<?php
/**
 * Notify
 *
 * @author      Shopimind <contact@shopimind.com>
 * @copyright   Copyright (c) 2013 - IDVIVE SARL (http://www.idvive.com)
 * @license     New BSD license (http://license.idvive.com)
 * @package     ShopimindClient
 * @version     $Id Notify.php 2013-05-21$
 */

require_once dirname(__FILE__).'/RequestServer.php';

class ShopimindClientNotify
{
    /**
     * Permet d'ordonner la synchronisation d'une commande
     *
     * @param array $params
     * @return boolean
     */
    public static function saveOrder($id_order)
    {
        $requestServer = new ShopimindClientRequestServer;
        $requestServer->setRestService('saveorder');
        $requestServer->addParam('order', array($id_order));
        if ($requestServer->send() === true) {
            return $requestServer->getResponse();
        }

        return false;
    }

    /**
     * Permet d'ordonner la synchronisation d'un client
     *
     * @param array $params
     * @return boolean
     */
    public static function saveCustomer($id_customer)
    {
        $requestServer = new ShopimindClientRequestServer;
        $requestServer->setRestService('savecustomer');
        $requestServer->addParam('customer', array($id_customer));
        if ($requestServer->send() === true) {
            return $requestServer->getResponse();
        }

        return false;
    }

    /**
     * Permet d'ordonner la synchronisation d'un groupe de clients
     *
     * @param array $params
     * @return boolean
     */
    public static function saveCustomerGroup($id_group)
    {
        $requestServer = new ShopimindClientRequestServer;
        $requestServer->setRestService('savecustomergroup');
        $requestServer->addParam('customergroup', array($id_group));
        if ($requestServer->send() === true) {
            return $requestServer->getResponse();
        }

        return false;
    }

    /**
     * Permet d'ordonner la synchronisation d'un fabricant
     *
     * @param array $params
     * @return boolean
     */
    public static function saveManufacturer($id_manufacturer)
    {
        $requestServer = new ShopimindClientRequestServer;
        $requestServer->setRestService('savemanufacturer');
        $requestServer->addParam('manufacturer', array($id_manufacturer));
        if ($requestServer->send() === true) {
            return $requestServer->getResponse();
        }

        return false;
    }

    /**
     * Permet d'ordonner la synchronisation d'un transporteur
     *
     * @param array $params
     * @return boolean
     */
    public static function saveCarrier($id_carrier)
    {
        $requestServer = new ShopimindClientRequestServer;
        $requestServer->setRestService('savecarrier');
        $requestServer->addParam('carrier', array($id_carrier));
        if ($requestServer->send() === true) {
            return $requestServer->getResponse();
        }

        return false;
    }

    /**
     * Permet d'ordonner la synchronisation d'un bon de réduction
     *
     * @param array $params
     * @return boolean
     */
    public static function saveVoucher($id_voucher)
    {
        $requestServer = new ShopimindClientRequestServer;
        $requestServer->setRestService('savevoucher');
        $requestServer->addParam('voucher', array($id_voucher));
        if ($requestServer->send() === true) {
            return $requestServer->getResponse();
        }

        return false;
    }

    /**
     * Permet d'ordonner la synchronisation d'un statut de commande
     *
     * @param array $params
     * @return boolean
     */
    public static function saveOrderStatus($id_status)
    {
        $requestServer = new ShopimindClientRequestServer;
        $requestServer->setRestService('saveorderstatus');
        $requestServer->addParam('orderstatus', array($id_status));
        if ($requestServer->send() === true) {
            return $requestServer->getResponse();
        }

        return false;
    }

    /**
     * Permet d'ordonner la synchronisation d'un produit
     *
     * @param array $params
     * @return boolean
     */
    public static function saveProduct($id_product)
    {
        $requestServer = new ShopimindClientRequestServer;
        $requestServer->setRestService('saveproduct');
        $requestServer->addParam('product', array($id_product));
        if ($requestServer->send() === true) {
            return $requestServer->getResponse();
        }

        return false;
    }

    /**
     * Permet d'ordonner la synchronisation d'une categorie de produit
     *
     * @param array $params
     * @return boolean
     */
    public static function saveProductCategory($id_category)
    {
        $requestServer = new ShopimindClientRequestServer;
        $requestServer->setRestService('saveproductcategory');
        $requestServer->addParam('productcategory', array($id_category));
        if ($requestServer->send() === true) {
            return $requestServer->getResponse();
        }

        return false;
    }

    /**
     * Permet d'ordonner la supression d'un client
     *
     * @param array $params
     * @return boolean
     */
    public static function deleteCustomer(array $params)
    {
        $requestServer = new ShopimindClientRequestServer;
        $requestServer->setRestService('deletecustomer');
        $requestServer->addParam('customer', array($params));
        if ($requestServer->send() == true) {
            return $requestServer->getResponse();
        }

        return false;
    }

    /**
     * Permet d'ordonner la supression d'un groupe de client
     *
     * @param array $params
     * @return boolean
     */
    public static function deleteCustomerGroup(array $params)
    {
        $requestServer = new ShopimindClientRequestServer;
        $requestServer->setRestService('deletecustomergroup');
        $requestServer->addParam('customergroup', array($params));
        if ($requestServer->send() === true) {
            return $requestServer->getResponse();
        }

        return false;
    }

    /**
     * Permet d'ordonner la supression d'un produit
     *
     * @param array $params
     * @return boolean
     */
    public static function deleteProduct(array $params)
    {
        $requestServer = new ShopimindClientRequestServer;
        $requestServer->setRestService('deleteproduct');
        $requestServer->addParam('product', array($params));
        if ($requestServer->send() === true) {
            return $requestServer->getResponse();
        }

        return false;
    }

    /**
     * Permet d'ordonner la supression d'une category de produit
     *
     * @param array $params
     * @return boolean
     */
    public static function deleteProductCategory(array $params)
    {
        $requestServer = new ShopimindClientRequestServer;
        $requestServer->setRestService('deleteproductcategory');
        $requestServer->addParam('productcategory', array($params));
        if ($requestServer->send() === true) {
            return $requestServer->getResponse();
        }

        return false;
    }

    /**
     * Permet d'ordonner la supression d'un fabricant
     *
     * @param array $params
     * @return boolean
     */
    public static function deleteManufacturer(array $params)
    {
        $requestServer = new ShopimindClientRequestServer;
        $requestServer->setRestService('deletemanufacturer');
        $requestServer->addParam('manufacturer', array($params));
        if ($requestServer->send() === true) {
            return $requestServer->getResponse();
        }

        return false;
    }

    /**
     * Permet d'ordonner la supression d'un fabricant
     *
     * @param array $params
     * @return boolean
     */
    public static function deleteCarrier(array $params)
    {
        $requestServer = new ShopimindClientRequestServer;
        $requestServer->setRestService('deletecarrier');
        $requestServer->addParam('carrier', array($params));
        if ($requestServer->send() === true) {
            return $requestServer->getResponse();
        }

        return false;
    }

    /**
     * Permet d'ordonner la supression d'un bon de réduction
     *
     * @param array $params
     * @return boolean
     */
    public static function deleteVoucher(array $params)
    {
        $requestServer = new ShopimindClientRequestServer;
        $requestServer->setRestService('deletevoucher');
        $requestServer->addParam('voucher', array($params));
        if ($requestServer->send() === true) {
            return $requestServer->getResponse();
        }

        return false;
    }

    /**
     * Permet d'ordonner la supression d'un statut de commande
     *
     * @param array $params
     * @return boolean
     */
    public static function deleteOrderStatus(array $params)
    {
        $requestServer = new ShopimindClientRequestServer;
        $requestServer->setRestService('deleteorderstatus');
        $requestServer->addParam('orderstatus', array($params));
        if ($requestServer->send() === true) {
            return $requestServer->getResponse();
        }

        return false;
    }
}
